/**
 * 
 */
package com.ptteng.sca.xqlease.common.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.xqlease.common.model.GoodsSort;
import com.ptteng.xqlease.common.service.GoodsSortService;

import java.util.List;
import java.util.Map;

public class GoodsSortSCAClient implements GoodsSortService {

    private GoodsSortService goodsSortService;

	public GoodsSortService getGoodsSortService() {
		return goodsSortService;
	}
	
	
	public void setGoodsSortService(GoodsSortService goodsSortService) {
		this.goodsSortService =goodsSortService;
	}
	
	
			   
		@Override
		public Long insert(GoodsSort goodsSort)throws ServiceException, ServiceDaoException{
		
		return goodsSortService.insert(goodsSort);
		          
		
		}	
		  
    	   
		@Override
		public List<GoodsSort> insertList(List<GoodsSort> goodsSortList)throws ServiceException, ServiceDaoException{
		
		return goodsSortService.insertList(goodsSortList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return goodsSortService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(GoodsSort goodsSort)throws ServiceException, ServiceDaoException{
		
		return goodsSortService.update(goodsSort);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<GoodsSort> goodsSortList)throws ServiceException, ServiceDaoException{
		
		return goodsSortService.updateList(goodsSortList);
		          
		
		}	
		  
    	   
		@Override
		public GoodsSort getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return goodsSortService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<GoodsSort> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return goodsSortService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getGoodsSortIdsBySortLevelOrderBySort(Integer sortLevel,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return goodsSortService.getGoodsSortIdsBySortLevelOrderBySort(sortLevel,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getGoodsSortIdsByShelfStatusOrderBySort(Integer shelfStatus,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return goodsSortService.getGoodsSortIdsByShelfStatusOrderBySort(shelfStatus,start,limit);
	
	
	}
	
			
			
		/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
        @Override
        public Long  getGoodsSortIdBySortNameOrderBySort(String sortName)throws ServiceException, ServiceDaoException{

            return goodsSortService.getGoodsSortIdBySortNameOrderBySort(sortName);




	}

		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countGoodsSortIdsBySortLevelOrderBySort(Integer sortLevel)throws ServiceException, ServiceDaoException{
		
		return goodsSortService.countGoodsSortIdsBySortLevelOrderBySort(sortLevel);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countGoodsSortIdsByShelfStatusOrderBySort(Integer shelfStatus)throws ServiceException, ServiceDaoException{
		
		return goodsSortService.countGoodsSortIdsByShelfStatusOrderBySort(shelfStatus);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countGoodsSortIdsBySortNameOrderBySort(String sortName)throws ServiceException, ServiceDaoException{
		
		return goodsSortService.countGoodsSortIdsBySortNameOrderBySort(sortName);
	
	
	}
	
		
	
		@Override
	public List<Long> getGoodsSortIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return goodsSortService.getGoodsSortIds(start, limit);
	}

	@Override
	public Integer countGoodsSortIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return goodsSortService.countGoodsSortIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return goodsSortService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return goodsSortService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   goodsSortService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.goodsSortService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long>  getGoodsSortIdsByFatherIdOrderBySort(Long fatherId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

        return goodsSortService.getGoodsSortIdsByFatherIdOrderBySort(fatherId,start,limit);


    }
 
}

