package com.ptteng.xqlease.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.xqlease.common.model.RentOrders;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface RentOrdersService extends BaseDaoService {

	



   		   
		
		public Long insert(RentOrders rentOrders)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<RentOrders> insertList(List<RentOrders> rentOrdersList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(RentOrders rentOrders)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<RentOrders> rentOrdersList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public RentOrders getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<RentOrders> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;


	   public Integer  countRentOrdersIdsByOrdersStatus(Integer ordersStatus)throws ServiceException, ServiceDaoException;

		public Integer  countRentOrdersIdsByOrdersStatusAndPayMethod(Integer ordersStatus,Integer payMethod)throws ServiceException, ServiceDaoException;




	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countRentOrdersIdsByOrdersNumber(Long ordersNumber)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countRentOrdersIdsByUid(Long uid)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getRentOrdersIdByOrdersNumber(String ordersNumber)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getRentOrdersIdsByUid(Long uid, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getRentOrdersIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countRentOrdersIds() throws ServiceException, ServiceDaoException;
	

	public List<Long> getRentOrdersByParentOrdersNumberAndOrderStatus(String parentOrdersNumber,Integer ordersStatus,Integer start, Integer limit)throws ServiceException, ServiceDaoException;

    public  List<Long> getRentOrdersByParentNumber(String parentOrdersNumber,Integer start, Integer limit)throws ServiceException, ServiceDaoException;

    public Integer  countRentOrdersIdsByUidAndOrdersType(Long uid,Integer ordersType)throws ServiceException, ServiceDaoException;

	public Integer  countRentOrdersIdsByUidAndOrdersStatus(Long uid,Integer ordersStatus)throws ServiceException, ServiceDaoException;

	public Integer  countRentOrdersIdsByUidAndOrdersTypeAndOrdersStatus(Long uid,Integer ordersType,Integer ordersStatus)throws ServiceException, ServiceDaoException;

}

