package com.ptteng.xqlease.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.xqlease.common.model.GoodsSku;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface GoodsSkuService extends BaseDaoService {

	



   		   
		
		public Long insert(GoodsSku goodsSku)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<GoodsSku> insertList(List<GoodsSku> goodsSkuList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(GoodsSku goodsSku)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<GoodsSku> goodsSkuList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public GoodsSku getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<GoodsSku> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countGoodsSkuIdsByGoodsId(Long goodsId)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getGoodsSkuIdsByGoodsIdOrderBySort(Long goodsId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getGoodsSkuIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countGoodsSkuIds() throws ServiceException, ServiceDaoException;


    public Long  getGoodsSkuIdBySkuNumber(String skuNumber)throws ServiceException, ServiceDaoException;


	public List<Long>  getGoodsSkuIdsByGoodsIdAndShelfStatusOrderBySortAndUpdateAt(Long goodsId, Integer shelfStatus,Integer start, Integer limit)throws ServiceException, ServiceDaoException;

	public List<Long>  getGoodsSkuIdsByShelfStatusAndGoodsId(Integer shelfStatus,Long goodsId,Integer start,Integer limit)throws ServiceException, ServiceDaoException;

	public Integer  countGoodsSkuIdsByShelfStatusAndGoodsId(Integer shelfStatus,Long goodsId)throws ServiceException, ServiceDaoException;

}

