package com.ptteng.xqlease.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "saled_orders_remark")
public class SaledOrdersRemark implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 5818263866944590848L;

    public static final int REMARK_ONLY = 1;
    public static final int REMARK_WITH_STATUS = 2;
    public static final int CHANGE_STATUS_WITHOUT_REMARK = 3;


    private Long id;


    private Long saledOrdersId;

    private String deviceNum;
    private String deviceSerialNum;
    private String remark;


    private Integer saledOrdersStatus;

    private Integer remarkType;
    private Integer operation;



    private Long createAt;


    private Long updateAt;


    private Long createBy;


    private Long updateBy;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "saled_orders_id")
    public Long getSaledOrdersId() {
        return saledOrdersId;
    }


    public void setSaledOrdersId(Long saledOrdersId) {
        this.saledOrdersId = saledOrdersId;
    }

    @Column(name = "remark")
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }


    @Column(name = "device_num")
    public String getDeviceNum() {
        return deviceNum;
    }

    public void setDeviceNum(String deviceNum) {
        this.deviceNum = deviceNum;
    }



    @Column(name = "device_serial_num")
    public String getDeviceSerialNum() {
        return deviceSerialNum;
    }

    public void setDeviceSerialNum(String deviceSerialNum) {
        this.deviceSerialNum = deviceSerialNum;
    }

    @Column(name = "saled_orders_status")
    public Integer getSaledOrdersStatus() {
        return saledOrdersStatus;
    }

    public void setSaledOrdersStatus(Integer saledOrdersStatus) {
        this.saledOrdersStatus = saledOrdersStatus;
    }


    @Column(name = "remark_type")
    public Integer getRemarkType() {
        return remarkType;
    }

    public void setRemarkType(Integer remarkType) {
        this.remarkType = remarkType;
    }


    @Column(name = "operation")
    public Integer getOperation() {
        return operation;
    }

    public void setOperation(Integer operation) {
        this.operation = operation;
    }


    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

