package com.ptteng.xqlease.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


@Entity
@Table(name = "saled_orders")
public class SaledOrders implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 4589316285019474944L;

    //售后服务-退货
    public static final int SALED_ORDER_TYPE_RETURN = 1;

    //售后服务-换货
    public static final int SALED_ORDER_TYPE_CHANGE = 2;

    //售后服务-返修
    public static final int SALED_ORDER_TYPE_FIX = 3;

    //售后服务-取消订单退款
    public static final int SALED_ORDER_CANCEL_REFUND = 4;

    //售后服务-退货退款
    public static final int SALED_ORDER_RETURN_REFUND = 5;


    //支付状态-未支付
    public static final int PAY_STATUS_NOT = 1;

    //支付状态-已支付
    public static final int PAY_STATUS_FINISH = 2;


    //售后订单状态-审核中
    public static final int SALED_ORDER_STATUS_CHECKING = 10;

    //售后订单状态-已拒绝
    public static final int SALED_ORDER_STATUS_REFUSED = 20;

    //售后订单状态-审核通过
    public static final int SALED_ORDER_STATUS_CHECK_ADOPT = 30;

    //售后订单状态-待发货
    public static final int SALED_ORDER_STATUS_NEED_DELIVER = 40;

    //售后订单状态-已发货
    public static final int SALED_ORDER_STATUS_DELIVERED = 50;

    //售后订单状态-待客户支付售后订单
    public static final int SALED_ORDER_STATUS_PYA_SALED_ORDERS = 60;

    //售后订单状态-退货待收货
    public static final int SALED_ORDER_NEED_RECEIVE = 70;

    //售后订单状态-售后申请订单已完成
    public static final int SALED_ORDER_STATUS_FINISH = 80;

    //售后订单状态-已拒绝退款申请
    public static final int REFUSED_REFUND = 90;

    //售后订单状态-已同意售后退款申请
    public static final int FINISH_REFUND = 100;


    //售后订单操作动作-创建售后订单
    public static final int CREATE_ORDERS = 10;

    //售后订单操作动作-审核通过售后申请
    public static final int ADOPT_SALED_ORDERS = 20;

    //售后订单操作动作-审核拒绝售后申请
    public static final int REFUSE_SALED_ORDERS = 30;

    //售后订单操作动作-确认收货
    public static final int RECEIVE_GOODS = 40;

    //售后订单操作动作-发货
    public static final int SEND_GOODS = 50;

    //售后订单操作动作-生成售后订单账单（后台填写维修费或违约金，点确认时调用）
    public static final int GENERATE_SALED_BILL = 60;

    //售后订单操作动作-支付退款单
    public static final int PAY_REFUND = 70;

    //售后订单操作动作-拒绝退款单
    public static final int REFUSE_REFUND = 80;

    //售后订单操作动作-换货返修订单完成
    public static final int FINISH_SALED_ORDERS = 90;




    /*售后-商品取货方式*/
    /**
     * 用户自提
     */
    public static final Integer USER_PICK = 10;
    /**
     * 德邦快递
     */
    public static final Integer DELIVERY_PICK = 20;
    /**
     * 送货上门
     */
    public static final Integer SEND_HOME = 30;


    private Long id;
    private Long uid;


    private String saledOrdersNum;


    private Integer saledOrdersType;

    private Long rentOid;
    private String rentOrdersNum;
    private Long rentOrdersDeviceRelationId;

    private String returnDeviceNum;

    private String returnDeviceSerialNum;

    private String sendDeviceNum;

    private String sendDeviceSerialNum;

    private Long sendAt;


    //售后订单费用，指：维修费   或  违约金
    private BigDecimal saledFee;


    private Integer payStatus;


    private String problem;


    private String imgs;


    private Integer saledOrdersStatus;

    private Integer pickupMethod;


    private String deliveryNum;


    private Long createAt;


    private Long updateAt;


    private Long createBy;


    private Long updateBy;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }


    @Column(name = "uid")
    public Long getUid() {
        return uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }


    @Column(name = "saled_orders_num")
    public String getSaledOrdersNum() {
        return saledOrdersNum;
    }

    public void setSaledOrdersNum(String saledOrdersNum) {
        this.saledOrdersNum = saledOrdersNum;
    }

    @Column(name = "saled_orders_type")
    public Integer getSaledOrdersType() {
        return saledOrdersType;
    }

    public void setSaledOrdersType(Integer saledOrdersType) {
        this.saledOrdersType = saledOrdersType;
    }


    @Column(name = "rent_orders_num")
    public String getRentOrdersNum() {
        return rentOrdersNum;
    }

    public void setRentOrdersNum(String rentOrdersNum) {
        this.rentOrdersNum = rentOrdersNum;
    }


    @Column(name = "rent_oid")
    public Long getRentOid() {
        return rentOid;
    }

    public void setRentOid(Long rentOid) {
        this.rentOid = rentOid;
    }


    @Column(name = "rent_orders_device_relation_id")
    public Long getRentOrdersDeviceRelationId() {
        return rentOrdersDeviceRelationId;
    }

    public void setRentOrdersDeviceRelationId(Long rentOrdersDeviceRelationId) {
        this.rentOrdersDeviceRelationId = rentOrdersDeviceRelationId;
    }


    @Column(name = "return_device_num")
    public String getReturnDeviceNum() {
        return returnDeviceNum;
    }

    public void setReturnDeviceNum(String returnDeviceNum) {
        this.returnDeviceNum = returnDeviceNum;
    }


    @Column(name = "return_device_serial_num")
    public String getReturnDeviceSerialNum() {
        return returnDeviceSerialNum;
    }

    public void setReturnDeviceSerialNum(String returnDeviceSerialNum) {
        this.returnDeviceSerialNum = returnDeviceSerialNum;
    }


    @Column(name = "send_device_num")
    public String getSendDeviceNum() {
        return sendDeviceNum;
    }

    public void setSendDeviceNum(String sendDeviceNum) {
        this.sendDeviceNum = sendDeviceNum;
    }


    @Column(name = "send_device_serial_num")
    public String getSendDeviceSerialNum() {
        return sendDeviceSerialNum;
    }

    public void setSendDeviceSerialNum(String sendDeviceSerialNum) {
        this.sendDeviceSerialNum = sendDeviceSerialNum;
    }


    @Column(name = "send_at")
    public Long getSendAt() {
        return sendAt;
    }

    public void setSendAt(Long sendAt) {
        this.sendAt = sendAt;
    }



    @Column(name = "saled_fee")
    public BigDecimal getSaledFee() {
        return saledFee;
    }

    public void setSaledFee(BigDecimal saledFee) {
        this.saledFee = saledFee;
    }


    @Column(name = "pay_status")
    public Integer getPayStatus() {
        return payStatus;
    }


    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }

    @Column(name = "problem")
    public String getProblem() {
        return problem;
    }


    public void setProblem(String problem) {
        this.problem = problem;
    }

    @Column(name = "imgs")
    public String getImgs() {
        return imgs;
    }


    public void setImgs(String imgs) {
        this.imgs = imgs;
    }

    @Column(name = "saled_orders_status")
    public Integer getSaledOrdersStatus() {
        return saledOrdersStatus;
    }


    public void setSaledOrdersStatus(Integer saledOrdersStatus) {
        this.saledOrdersStatus = saledOrdersStatus;
    }


    @Column(name = "pickup_method")
    public Integer getPickupMethod() {
        return pickupMethod;
    }

    public void setPickupMethod(Integer pickupMethod) {
        this.pickupMethod = pickupMethod;
    }


    @Column(name = "delivery_num")
    public String getDeliveryNum() {
        return deliveryNum;
    }


    public void setDeliveryNum(String deliveryNum) {
        this.deliveryNum = deliveryNum;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

