package com.ptteng.xqlease.common.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


@Entity
@Table(name = "goods_sku")
public class GoodsSku implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 748956930072087552L;

    /**
     * 上架状态
     */
    public static final Integer SHELF_ON = 2;

    /**
     * 下架状态
     */
    public static final Integer SHELF_OFF = 1;

    /**
     * 初始顺序
     */
    public static final Integer DEFAULT_SORT = 0;


    /**  sku是否包含短租租期 1-无短租 2-有短租 */
    public static  final  Integer SHORT_PERIOD_NO=1;
    public static  final  Integer SHORT_PERIOD_YES=2;


    private Long id;


    private Long goodsId;


    private String skuNumber;


    private String skuAttributes;


    private String skuDetails;


    private Integer skuHash;


    private BigDecimal keepFee;

    private String securityIds;
private List<Long> securityIdsList;

    private Long increaseNum;


    private Integer stock;


    private Integer totalSales;


    private Integer shelfStatus;

    private Integer sort;

    private Integer shortPeriodStatus;

    private Long createAt;


    private Long updateAt;


    private Long createBy;


    private Long updateBy;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "goods_id")
    public Long getGoodsId() {
        return goodsId;
    }


    public void setGoodsId(Long goodsId) {
        this.goodsId = goodsId;
    }

    @Column(name = "sku_number")
    public String getSkuNumber() {
        return skuNumber;
    }


    public void setSkuNumber(String skuNumber) {
        this.skuNumber = skuNumber;
    }

    @Column(name = "sku_attributes")
    public String getSkuAttributes() {
        return skuAttributes;
    }


    public void setSkuAttributes(String skuAttributes) {
        this.skuAttributes = skuAttributes;
    }

    @Column(name = "sku_details")
    public String getSkuDetails() {
        return skuDetails;
    }


    public void setSkuDetails(String skuDetails) {
        this.skuDetails = skuDetails;
    }

    @Column(name = "sku_hash")
    public Integer getSkuHash() {
        return skuHash;
    }


    public void setSkuHash(Integer skuHash) {
        this.skuHash = skuHash;
    }

    @Column(name = "keep_fee")
    public BigDecimal getKeepFee() {
        return keepFee;
    }


    public void setKeepFee(BigDecimal keepFee) {
        this.keepFee = keepFee;
    }

    @Column(name = "security_ids")
    public String getSecurityIds() {
        return securityIds;
    }

    public void setSecurityIds(String securityIds) {
        this.securityIds = securityIds;

        Gson gson = new GsonBuilder().create();
        securityIdsList = gson.fromJson(this.securityIds, new TypeToken<List<Long>>() {
        }.getType());
    }


    @Transient
    public List<Long> getSecurityIdsList() {
        if (StringUtils.isBlank(this.securityIds)) {
            return new ArrayList<>();
        } else {
            if (this.securityIds == null) {
                Gson gson = new GsonBuilder().create();
                securityIdsList = gson.fromJson(this.securityIds, new TypeToken<List<Long>>() {
                }.getType());
            }
        }
        return securityIdsList;
    }

    public void setSecurityIdsList(List<Long> securityIdsList) {
        this.securityIdsList = securityIdsList;
        Gson gson = new GsonBuilder().create();
        this.securityIds = gson.toJson(securityIdsList);
    }
    

    @Column(name = "increase_num")
    public Long getIncreaseNum() {
        return increaseNum;
    }


    public void setIncreaseNum(Long increaseNum) {
        this.increaseNum = increaseNum;
    }

    @Column(name = "stock")
    public Integer getStock() {
        return stock;
    }


    public void setStock(Integer stock) {
        this.stock = stock;
    }

    @Column(name = "total_sales")
    public Integer getTotalSales() {
        return totalSales;
    }


    public void setTotalSales(Integer totalSales) {
        this.totalSales = totalSales;
    }

    @Column(name = "shelf_status")
    public Integer getShelfStatus() {
        return shelfStatus;
    }


    public void setShelfStatus(Integer shelfStatus) {
        this.shelfStatus = shelfStatus;
    }

    @Column(name = "sort")
    public Integer getSort() {
        return sort;
    }


    public void setSort(Integer sort) {
        this.sort = sort;
    }

    @Column(name = "short_period_status")
    public Integer getShortPeriodStatus() {
        return shortPeriodStatus;
    }


    public void setShortPeriodStatus(Integer shortPeriodStatus) {
        this.shortPeriodStatus = shortPeriodStatus;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

    public static void main(String[] args) {
        GoodsSku sku= new GoodsSku();
        sku.setSecurityIds("[\"1\",\"2\"]");
        System.out.println("sku.getSecurityIdsList().get(0) = " + sku.getSecurityIdsList().get(0));
    }
    
    
    
    
}

