package com.ptteng.xqlease.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


@Entity
@Table(name = "bill")
public class Bill implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 661511846112024576L;

    //账单生成状态 未生成 
    public static final int BILL_NOT_CREATE = 1;
    //账单生成状态 已生成
    public static final int BILL_CREATED = 2;


    //账单类型-租赁
    public static final int BILL_TYPE_RENT = 10;
    //账单类型-多个租赁账单合并的父账单
    public static final int BILL_TYPE_RENT_PARENT = 11;
    //账单类型-售后服务费
    public static final int BILL_TYPE_SALED = 20;
    //账单类型-违约
    public static final int BILL_TYPE_BREAK = 30;

    //支付状态-未支付
    public static final int PAY_NOT = 1;
    //支付状态-已支付
    public static final int PAY_FINISH = 2;

    /*账单开票状态*/
    //未申请
    public static final int NOT_APPLY_TICKET = 1;
    //已开票
    public static final int HAS_TICKET = 2;
    //审核中
    public static final int CHECKING_TICKET = 3;
    //已拒绝
    public static final int REFUSED_TICKET = 4;


    private Long id;

    private Long parentBillId;

    private Long uid;

    private Long deviceRelationId;

    private String billNum;

    private Integer billType;


    private Long rentOid;

    private String rentOrdersNum;


    private Long saledOid;

    private String saledOrdersNum;


    private String deviceNum;


    private String deviceSerialNum;


    private BigDecimal rentFee;


    private BigDecimal securityFee;


    private BigDecimal discountFee;


    private BigDecimal saledFee;


    private BigDecimal totalFee;


    private Long periodStart;


    private Long periodEnd;


    private Integer periodNum;


    private Integer billCreateStatus;


    private Integer payStatus;


    private Integer payMethod;

    private String payAccount;


    private Integer applyTicketStatus;


    private Long createAt;


    private Long updateAt;


    private Long createBy;


    private Long updateBy;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "parent_bill_id")
    public Long getParentBillId() {
        return parentBillId;
    }

    public void setParentBillId(Long parentBillId) {
        this.parentBillId = parentBillId;
    }


    @Column(name = "device_relation_id")
    public Long getDeviceRelationId() {
        return deviceRelationId;
    }

    public void setDeviceRelationId(Long deviceRelationId) {
        this.deviceRelationId = deviceRelationId;
    }


    @Column(name = "uid")
    public Long getUid() {
        return uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }


    @Column(name = "bill_num")
    public String getBillNum() {
        return billNum;
    }

    public void setBillNum(String billNum) {
        this.billNum = billNum;
    }


    @Column(name = "bill_type")
    public Integer getBillType() {
        return billType;
    }

    public void setBillType(Integer billType) {
        this.billType = billType;
    }


    @Column(name = "rent_oid")
    public Long getRentOid() {
        return rentOid;
    }

    public void setRentOid(Long rentOid) {
        this.rentOid = rentOid;
    }


    @Column(name = "rent_orders_num")
    public String getRentOrdersNum() {
        return rentOrdersNum;
    }

    public void setRentOrdersNum(String rentOrdersNum) {
        this.rentOrdersNum = rentOrdersNum;
    }


    @Column(name = "saled_oid")
    public Long getSaledOid() {
        return saledOid;
    }

    public void setSaledOid(Long saledOid) {
        this.saledOid = saledOid;
    }


    @Column(name = "saled_orders_num")
    public String getSaledOrdersNum() {
        return saledOrdersNum;
    }

    public void setSaledOrdersNum(String saledOrdersNum) {
        this.saledOrdersNum = saledOrdersNum;
    }


    @Column(name = "device_num")
    public String getDeviceNum() {
        return deviceNum;
    }


    public void setDeviceNum(String deviceNum) {
        this.deviceNum = deviceNum;
    }

    @Column(name = "device_serial_num")
    public String getDeviceSerialNum() {
        return deviceSerialNum;
    }


    public void setDeviceSerialNum(String deviceSerialNum) {
        this.deviceSerialNum = deviceSerialNum;
    }

    @Column(name = "rent_fee")
    public BigDecimal getRentFee() {
        return rentFee;
    }


    public void setRentFee(BigDecimal rentFee) {
        this.rentFee = rentFee;
    }

    @Column(name = "discount_fee")
    public BigDecimal getDiscountFee() {
        return discountFee;
    }

    public void setDiscountFee(BigDecimal discountFee) {
        this.discountFee = discountFee;
    }


    @Column(name = "security_fee")
    public BigDecimal getSecurityFee() {
        return securityFee;
    }

    public void setSecurityFee(BigDecimal securityFee) {
        this.securityFee = securityFee;
    }


    @Column(name = "saled_fee")
    public BigDecimal getSaledFee() {
        return saledFee;
    }


    public void setSaledFee(BigDecimal saledFee) {
        this.saledFee = saledFee;
    }


    @Column(name = "total_fee")
    public BigDecimal getTotalFee() {
        return totalFee;
    }

    public void setTotalFee(BigDecimal totalFee) {
        this.totalFee = totalFee;
    }


    @Column(name = "period_start")
    public Long getPeriodStart() {
        return periodStart;
    }


    public void setPeriodStart(Long periodStart) {
        this.periodStart = periodStart;
    }

    @Column(name = "period_end")
    public Long getPeriodEnd() {
        return periodEnd;
    }


    public void setPeriodEnd(Long periodEnd) {
        this.periodEnd = periodEnd;
    }

    @Column(name = "period_num")
    public Integer getPeriodNum() {
        return periodNum;
    }


    public void setPeriodNum(Integer periodNum) {
        this.periodNum = periodNum;
    }

    @Column(name = "bill_create_status")
    public Integer getBillCreateStatus() {
        return billCreateStatus;
    }


    public void setBillCreateStatus(Integer billCreateStatus) {
        this.billCreateStatus = billCreateStatus;
    }

    @Column(name = "pay_status")
    public Integer getPayStatus() {
        return payStatus;
    }


    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }

    @Column(name = "pay_method")
    public Integer getPayMethod() {
        return payMethod;
    }

    public void setPayMethod(Integer payMethod) {
        this.payMethod = payMethod;
    }



    @Column(name = "pay_account")
    public String getPayAccount() {
        return payAccount;
    }

    public void setPayAccount(String payAccount) {
        this.payAccount = payAccount;
    }


    @Column(name = "apply_ticket_status")
    public Integer getApplyTicketStatus() {
        return applyTicketStatus;
    }

    public void setApplyTicketStatus(Integer applyTicketStatus) {
        this.applyTicketStatus = applyTicketStatus;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

