package com.ptteng.xqlease.common.debang.domain.order;

import com.ptteng.xqlease.common.debang.util.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper=false)
public class EwbOrderAddReqInfo extends BaseEntity implements Serializable {
	
	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 8137001153607640138L;
	
	/******************** 运单号(电子运单二期预订德邦运单号必填项) ********************/
	private String mailNo;

	// 物流公司ID 固定值DEPPON
	private String logisticCompanyID;

	/******************** 物流编号（电子运单二期平台的订单号必填项） ********************/
	private String logisticID;

	// 订单来源与companyCode一致
	private String orderSource;

	// 服务类型
	private String serviceType;

	/******************** 用户唯一ID号(用户名必填项) ********************/
	private String customerID;

	/******************** 客户编码号(必填项) ********************/
	private String customerCode;

	// 是否推荐物流（必接）单 0/1(菜鸟项目选填项)
	private String isRecommend;

	// 营业网点编号--营业部编码
	private String businessNetworkNo;

	// 增加到达部门编码
	private String toNetworkNo;

	// 发货人
	private Contacts sender;

	// 收货人
	private Contacts receiver;

	// 订单提交时间
	private Date gmtCommit;

	// 货物名称
	private String cargoName;

	// 特殊商品性质
	private String special;

	// 总件数
	private int totalNumber; // long

	/******************** 总重量(计费重量必填) ********************/
	private double totalWeight;

	// 总体积
	private double totalVolume;

	// 支付方式：0 发货人付款（现付） 1 收货人付款（到付）
	private String payType;

	// 运输方式 HK_JZHK:精准空运 QC_JZKH:精准卡航 QC_JZQYC:精准汽运（长） QC_JZQYD:精准汽运（短）
	// QC_JZCY:精准城运 QC_JZDPBZJ:精准大票标准件
	private String transportType;

	// 保价金额
	private BigDecimal insuranceValue;

	// 代收货款类型(3：三日退 1：即日退，当代收款不为空或0值时，必填)
	private String codType;

	// 代收货款
	private BigDecimal codValue;

	// 代收货款客户账号(当代收款不为空或0值时，必填)
	private String reciveLoanAccount;

	// 代收货款客户开户名(当代收款不为空或0值时，必填)
	private String accountName;

	// 上门接货： Y 需要上门接货 N 客户自送
	private String vistReceive;

	// 上门接货开始时间
	private Date sendStartTime;

	// 上门接货结束时间
	private Date sendEndTime;

	// 送货方式： 1 自提 0 送货（不含上楼） 4 机场自提 6 送货上楼
	private String deliveryType;

	// 签收回单
	// 0 无需返单 1 客户签收单原件返回 2 客户签收单传真返回 3 运单签收联原件返回 4 运单签收联传真返回
	private String backSignBill;

	// 包装 (纸、 纤、 木箱、 木架、托膜、 托木)
	private String packageService;

	// 等通知发货： Y 等通知发货 N 不需要等通知发货
	private String waitNotifySend;

	// 短信通知： Y 需要 N 不需要
	private String smsNotify;

	// 备注
	private String remark;
	
	/**
	 * 是否外发 ： Y  N
	 */
	private String isOut;

}
