package com.ptteng.xqlease.common.debang.domain.order;

import lombok.Data;

import java.util.Date;

/**
 * 电子运单二期电子运单 Action
 * 
 * @version V1.0
 * @description 快递电子运单下单（异步） 请求参数
 * @author 覃业涛
 * @date 2016-08-26
 */
@Data
public class EwbNewOrderInfo {
	// 签收回单,0:无需返单 2:客户签收单传真返回4: 运单到达联传真返回
	private String backSignBill;
	// 货物名称
	private String cargoName;
	// 代收货款类型
	private String codType;
	// 代收货款金额
	private Double codValue;
	// 客户编码
	private String customerCode;
	// 渠道用户，标志下单用户身份的ID，与companyCode保持一致
	private String customerID;
	// 送货方式
	private String deliveryType;
	// 上门接货结束时间
	private Date sendEndTime;
	// 上门接货开始时间
	private Date sendStartTime;
	// 报价金额
	private Double insuranceValue;
	// 物流公司ID，为“DEPPON”
	private String logisticCompanyID;
	// 代收货款客户开户名
	private String accountName;
	// 代收货款客户账号
	private String reciveLoanAccount;
	// 订单来源
	private String orderSource;
	// 渠道单号
	private String logisticID;
	// 运单号
	private String mailNo;
	// 服务类型，2．快递在线下单 3、快递线下订单
	private String serviceType;
	// 支付方式||付款方式，0:发货人付款（现付）1:收货人付款（到付）2:发货人付款（月结）（电子运单客户仅支持月结支付）
	private String payType;
	// 订单提交时间
	private Date gmtCommit;
	// private String sieveOrder;
	// 收货人
	private TransPeopleInfo receiver;
	// 是否推荐物流,0:否1:是 可为空，客户未填默认为否
	private String isRecommend;
	// 发货人
	private TransPeopleInfo sender;
	// 短信通知 Y：需要 N: 不需要
	private String smsNotify;
	// 到达部门编码
	private String toNetworkNo;
	// 发货部门编码
	private String businessNetworkNo;
	// 总件数
	private Integer totalNumber;
	// 体积
	private Double totalVolume;
	// 重量
	private Double totalWeight;
	// 运输方式
	private String transportType;
	// 是否上门接货,是:Y 否：N；如为空，系统默认值为否。快递客户如需上门接货请传“Y”；
	private String vistReceive;
	// 包装
	private String packageService;
	// 注意事项（备注）
	private String remark;
	// 特殊商品性质，普通[0]、易碎[1]、液态[2]、化学品[3]、白色粉末状[4]、香烟[5]
	private String special;
	

	// 收货和寄件 信息
	public @Data
	class TransPeopleInfo {
		/**
		 * 发、收货公司名称
		 */
		private String companyName;
		/**
		 * 收、发货人姓名
		 */
		private String name;
		/**
		 * 邮编
		 */
		private String postCode;
		/**
		 * 电话
		 */
		private String phone;
		/**
		 * 手机
		 */
		private String mobile;
		/**
		 * 省份
		 */
		private String province;
		/**
		 * 城市
		 */
		private String city;
		/**
		 * 县/区
		 */
		private String county;

		/**
		 * 街道镇（五级地址菜鸟项目使用）
		 */
		private String street;

		/**
		 * 原始地址（菜鸟项目使用）
		 */
		private String originalAddress;

		/**
		 * 详细地址（详细地址不做校验，因为不是所有的渠道都有详细地址）
		 */
		private String address;
	}

}
