package com.ptteng.xqlease.common.debang.domain.errorcode;
import lombok.Getter;

/**
 * @author 杨长燕
 * @version V1.0
 * @Description 返回结果编码枚举
 * @Time 2013-5-13
 */
public enum ResultCode implements ErrorCode {

	/**
	 * 结果代码 说明 备注 1000 成功 1001 订单已存在 1002 订单不存在 1003 运单已存在 1004 操作不允许
	 * 只能对本公司订单进行操作 1007 订单不允许撤销 2001 白名单验证失败 2002 摘要验证失败 2003 时间戳验证失败 2004
	 * 公司编码验证失败 2005 参数转换失败 2006 参数校验失败 3001 接口调用失败 9000 未知异常 9999 系统异常
	 */

	SUCCESS("1000", "成功"), ORDER_EXIST("1001", "订单已存在"), ORDER_NOT_EXIST(
			"1002", "订单不存在"), WAYBILL_NUMBER_EXIST("1003", "运单已存在"), OPERATE_NOT_ALLOW(
			"1004", "操作不允许"), WAYBILL_NUMBER_NOT_EXIST("1005", "运单不存在"),HTTP_METHOD_ERROR("3007", "请使用HTTP POST请求访问"), TRADE_NUMBER_NOT_EXIST(
			"1006", "流水号不存在"), CANCEL_NOT_ALLOW("1007", "订单不允许撤销"), SIEVE_EWB_FAILED(
			"1008", "此电子运单筛单为失败"), SIEVE_EWB_REPEAT("1009", "此电子运单已重复筛单"), SAVE_EWB_FAILED(
			"1010", "此电子运单下单失败"), NOT_ACCEPT("1011", "该订单无法承运"), GET_WAYBILLNO_FAILD(
			"1012", "获取运单号失败"), IP_NOT_IN_WHITE_LIST("2001", "白名单验证失败"), DIGEST_ERROR(
			"2002", "摘要验证失败"), TIMESTAMP_ERROR("2003", "时间戳验证失败"), ECCOMPANYID_ERROR(
			"2004", "公司编码验证失败"), PARAMS_CONVERT_ERROR("2005", "参数转换失败"), PARAMS_VALIDATE_ERROR(
			"2006", "参数校验失败"), CALL_REMOTE_ERROR("3001", "接口调用失败"), INTERFACE_PERMISSION_ERROR(
			"3002", "接口权限不足"), COMPANY_ACTIVE_ERROR("3003", "公司编码待激活"), INTERFACE_ACTIVE_ERROR(
			"3004", "接口待激活"), UNKNOWN_ERROR("9000", "未知异常"), SYSTEM_ERROR(
			"9999", "系统异常"), CN_SYSTEM_FAIL("B0001", "System Failure"),SYNC_STATUS_ERROR(
			"3008","状态推送异常"),SENDER_NAME_ERROR("3009","发货人信息为空"),REVICE_NAME_ERROR(
			"3010", "收货人信息为空"), LINKMAN_ERROR("3111","收货人或发货人异常"),REVICE_PHONE_ERROR(
			"3011", "收货人电话为空"),SENDER_PHONE_ERROR("3012","发货人电话为空"),REVICE_ADDRESS_ERROR(
			"3013", "收货人地址信息错误"),SENDER_ADDRESS_ERROR("3014","发货人地址信息错误"),DELIVERY_TYPE(
			"3015", "提货方式为空"),PAY_TYPE("3016","支付方式为空"),LIMIT_IP_REQUEST("3017","您的访问太频繁，请稍后再试"),
			SAVE_LOGISTICS_ORDER_REPEAT("3018","渠道单号或运单号重复"),QUERY_PRICE_PARAM_ERROR("3019","出发到达省市区为必填项"),
			CUSTOMER_CODE_IS_NULL_ERROR("2007", "客户编码未传"), NO_MULTIPLE_ORDER_PERMISSION("2008", "渠道单号重复"),
			NO_SAVE_MUTILPLEORDER_AUTH("2009", "该客户编码没有子母件下单权限"),SAVE_MAILNO_ORDER_REPEAT("2010","运单号重复"),
			DIFF_CUSTOMER_CODE("2011", "客户编码与首次下单时不一致"), ORDER_COUNT_ERROR("2022", "订单总数必须为有效个数");
	/**
	 * getter number
	 */
	private @Getter
	String number;
	/**
	 * getter message
	 */
	private @Getter
	String message;

	/**
	 * ResultCode
	 * 
	 * @date 2016-5-23 下午12:44:20
	 * @param number
	 * @param message
	 */
	private ResultCode(String number, String message) {
		this.number = number;
		this.message = message;
	}

}