/**
 * 
 */
package com.ptteng.sca.xqlease.common.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.xqlease.common.model.Ticket;
import com.ptteng.xqlease.common.service.TicketService;

import java.util.List;
import java.util.Map;

public class TicketSCAClient implements TicketService {

    private TicketService ticketService;

	public TicketService getTicketService() {
		return ticketService;
	}
	
	
	public void setTicketService(TicketService ticketService) {
		this.ticketService =ticketService;
	}
	
	
			   
		@Override
		public Long insert(Ticket ticket)throws ServiceException, ServiceDaoException{
		
		return ticketService.insert(ticket);
		          
		
		}	
		  
    	   
		@Override
		public List<Ticket> insertList(List<Ticket> ticketList)throws ServiceException, ServiceDaoException{
		
		return ticketService.insertList(ticketList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return ticketService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Ticket ticket)throws ServiceException, ServiceDaoException{
		
		return ticketService.update(ticket);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Ticket> ticketList)throws ServiceException, ServiceDaoException{
		
		return ticketService.updateList(ticketList);
		          
		
		}	
		  
    	   
		@Override
		public Ticket getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return ticketService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Ticket> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return ticketService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getTicketIdsByUidAndTicketStatusOrderByUpdateAt(Long uid,Integer ticketStatus,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return ticketService.getTicketIdsByUidAndTicketStatusOrderByUpdateAt(uid,ticketStatus,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getTicketIdsByUidOrderByUpdateAt(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return ticketService.getTicketIdsByUidOrderByUpdateAt(uid,start,limit);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countTicketIdsByUidAndTicketStatusOrderByUpdateAt(Long uid,Integer ticketStatus)throws ServiceException, ServiceDaoException{
		
		return ticketService.countTicketIdsByUidAndTicketStatusOrderByUpdateAt(uid,ticketStatus);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countTicketIdsByUidOrderByUpdateAt(Long uid)throws ServiceException, ServiceDaoException{
		
		return ticketService.countTicketIdsByUidOrderByUpdateAt(uid);
	
	
	}
	
		
	
		@Override
	public List<Long> getTicketIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return ticketService.getTicketIds(start, limit);
	}

	@Override
	public Integer countTicketIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return ticketService.countTicketIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return ticketService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return ticketService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   ticketService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.ticketService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


 
}

