/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.xqlease.common.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Entity
@Table(name="goods_sku")
public class GoodsSku
implements Serializable {
    private static final long serialVersionUID = 748956930072087552L;
    public static final Integer SHELF_ON = 2;
    public static final Integer SHELF_OFF = 1;
    public static final Integer DEFAULT_SORT = 0;
    public static final Integer SHORT_PERIOD_NO = 1;
    public static final Integer SHORT_PERIOD_YES = 2;
    private Long id;
    private Long goodsId;
    private String skuNumber;
    private String skuAttributes;
    private String skuDetails;
    private Integer skuHash;
    private BigDecimal keepFee;
    private String securityIds;
    private List<Long> securityIdsList;
    private Long increaseNum;
    private Integer stock;
    private Integer totalSales;
    private Integer shelfStatus;
    private Integer sort;
    private Integer shortPeriodStatus;
    private Long createAt;
    private Long updateAt;
    private Long createBy;
    private Long updateBy;

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="id")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="goods_id")
    public Long getGoodsId() {
        return this.goodsId;
    }

    public void setGoodsId(Long goodsId) {
        this.goodsId = goodsId;
    }

    @Column(name="sku_number")
    public String getSkuNumber() {
        return this.skuNumber;
    }

    public void setSkuNumber(String skuNumber) {
        this.skuNumber = skuNumber;
    }

    @Column(name="sku_attributes")
    public String getSkuAttributes() {
        return this.skuAttributes;
    }

    public void setSkuAttributes(String skuAttributes) {
        this.skuAttributes = skuAttributes;
    }

    @Column(name="sku_details")
    public String getSkuDetails() {
        return this.skuDetails;
    }

    public void setSkuDetails(String skuDetails) {
        this.skuDetails = skuDetails;
    }

    @Column(name="sku_hash")
    public Integer getSkuHash() {
        return this.skuHash;
    }

    public void setSkuHash(Integer skuHash) {
        this.skuHash = skuHash;
    }

    @Column(name="keep_fee")
    public BigDecimal getKeepFee() {
        return this.keepFee;
    }

    public void setKeepFee(BigDecimal keepFee) {
        this.keepFee = keepFee;
    }

    @Column(name="security_ids")
    public String getSecurityIds() {
        return this.securityIds;
    }

    public void setSecurityIds(String securityIds) {
        this.securityIds = securityIds;
        Gson gson = new GsonBuilder().create();
        this.securityIdsList = (List)gson.fromJson(this.securityIds, new TypeToken<List<Long>>(){}.getType());
    }

    @Transient
    public List<Long> getSecurityIdsList() {
        if (StringUtils.isBlank((CharSequence)this.securityIds)) {
            return new ArrayList<Long>();
        }
        if (this.securityIds == null) {
            Gson gson = new GsonBuilder().create();
            this.securityIdsList = (List)gson.fromJson(this.securityIds, new TypeToken<List<Long>>(){}.getType());
        }
        return this.securityIdsList;
    }

    public void setSecurityIdsList(List<Long> securityIdsList) {
        this.securityIdsList = securityIdsList;
        Gson gson = new GsonBuilder().create();
        this.securityIds = gson.toJson(securityIdsList);
    }

    @Column(name="increase_num")
    public Long getIncreaseNum() {
        return this.increaseNum;
    }

    public void setIncreaseNum(Long increaseNum) {
        this.increaseNum = increaseNum;
    }

    @Column(name="stock")
    public Integer getStock() {
        return this.stock;
    }

    public void setStock(Integer stock) {
        this.stock = stock;
    }

    @Column(name="total_sales")
    public Integer getTotalSales() {
        return this.totalSales;
    }

    public void setTotalSales(Integer totalSales) {
        this.totalSales = totalSales;
    }

    @Column(name="shelf_status")
    public Integer getShelfStatus() {
        return this.shelfStatus;
    }

    public void setShelfStatus(Integer shelfStatus) {
        this.shelfStatus = shelfStatus;
    }

    @Column(name="sort")
    public Integer getSort() {
        return this.sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    @Column(name="short_period_status")
    public Integer getShortPeriodStatus() {
        return this.shortPeriodStatus;
    }

    public void setShortPeriodStatus(Integer shortPeriodStatus) {
        this.shortPeriodStatus = shortPeriodStatus;
    }

    @Column(name="create_at")
    public Long getCreateAt() {
        return this.createAt;
    }

    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name="update_at")
    public Long getUpdateAt() {
        return this.updateAt;
    }

    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name="create_by")
    public Long getCreateBy() {
        return this.createBy;
    }

    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name="update_by")
    public Long getUpdateBy() {
        return this.updateBy;
    }

    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    public static void main(String[] args) {
        GoodsSku sku = new GoodsSku();
        sku.setSecurityIds("[\"1\",\"2\"]");
        System.out.println("sku.getSecurityIdsList().get(0) = " + sku.getSecurityIdsList().get(0));
    }
}

