/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.xqlease.common.debang.domain.result;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ResultDO<T> {
    private T model;
    private Map<String, Object> extra = Maps.newConcurrentMap();
    private List<Exception> exceptionList = Lists.newArrayList();

    public ResultDO set(String key, Object value) {
        if (StringUtils.isBlank((String)key) || null == value) {
            throw new IllegalArgumentException("argument is empty");
        }
        this.extra.put(key, value);
        return this;
    }

    public Object get(String key) {
        if (StringUtils.isBlank((String)key)) {
            return null;
        }
        return this.extra.get(key);
    }

    public ResultDO<T> setException(Exception exception) {
        return this.addException(exception);
    }

    public ResultDO<T> setModel(T model) {
        this.model = model;
        return this;
    }

    public ResultDO<T> addException(Exception ex) {
        if (null != ex) {
            this.exceptionList.add(ex);
        }
        return this;
    }

    public ResultDO<T> addExceptionList(List<Exception> exList) {
        if (CollectionUtils.isNotEmpty(exList)) {
            this.exceptionList.addAll(exList);
        }
        return this;
    }

    public boolean isSuccess() {
        return CollectionUtils.isEmpty(this.exceptionList);
    }

    public Exception getException() {
        return CollectionUtils.isNotEmpty(this.exceptionList) ? this.exceptionList.get(0) : null;
    }

    public List<Exception> getExceptionList() {
        return Collections.unmodifiableList(this.exceptionList);
    }

    public T getModel() {
        return this.model;
    }
}

