package com.ptteng.studyabroad.util;


import com.ptteng.common.dao.util.SQLUtil;
import com.ptteng.studyabroad.admin.model.Manager;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.HashMap;
import java.util.Map;


public class DynamicUtil {

    private static final Log log = LogFactory.getLog(DynamicUtil.class);



    /**
     * Article搜索
     * @param title
     * @param author
     * @param createBy
     * @param status
     * @param startAt
     * @param endAt
     * @return
     */

    public static Map<String, Object> getArticleList(String title, String author, String createBy, Integer status, Long startAt, Long endAt) {
        Map<String, Object> param = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(title)) {
            param.put("a.title & like", "'%" + title + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(author)) {
            param.put("a.author & like", "'%" + author + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(createBy)) {
            param.put("m.name & like", "'%" + createBy + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            param.put("a.status", status);
        }
        if (DataUtils.isNotNullOrEmpty(startAt)) {
            param.put("a.createAt & >= ", startAt);
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            param.put("a.createAt & <= ", endAt);
        }
        param.put("a.createBy", "m.id");
        param.put("@order", "a.rank asc");
        param.put("@query", "a.id");
        param.put("@table", "article a,manager m");
        log.info("getArticleList sql is " + SQLUtil.convert2Sql(param,0, Integer.MAX_VALUE));
        return param;

    }

    /**
     * train搜索
     * @param language
     * @param classType
     * @param teacherType
     * @param status
     * @param startAt
     * @param endAt
     * @param week
     * @return
     */
    public static Map<String,Object> getTrainList(Integer language, Integer classType, Integer teacherType, Integer status, Long startAt, Long endAt, Integer week) {

        Map<String, Object> param = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(language)) {
            param.put("language", language);
        }
        if (DataUtils.isNotNullOrEmpty(classType)) {
            param.put("classType", classType);
        }
        if (DataUtils.isNotNullOrEmpty(teacherType)) {
            param.put("teacherType", teacherType);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            param.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty(startAt)) {
            param.put("createAt & >= ", startAt);
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            param.put("createAt & <= ", endAt);
        }
        if (DataUtils.isNotNullOrEmpty(week)) {
            param.put("week & like ", "'%" + week + "%'");
        }
        param.put("@order", "createAt desc");
        param.put("@query", "id");
        param.put("@table", "train");
        log.info(SQLUtil.convert2Sql(param, 0, Integer.MAX_VALUE));

        return param;
    }


    public static Map<String, Object> getReserveUser(String name) {
        Map<String, Object> param = new HashMap<>();
        param.put("@query", "id");
        param.put("@table", "reserve_user");
        param.put("name ", "'"+name +"'");
        log.info(SQLUtil.convert2Sql(param, 0, Integer.MAX_VALUE));
        return param;
    }

    public static Map<String, Object> getReserveUserMobile(String mobile) {
        Map<String, Object> param = new HashMap<>();
        param.put("@query", "id");
        param.put("@table", "reserve_user");
        param.put("mobile", "'" + mobile + "'");
        log.info(SQLUtil.convert2Sql(param, 0, Integer.MAX_VALUE));
        return param;
    }



}
