package com.ptteng.studyabroad.controller;

import com.ptteng.studyabroad.admin.model.Train;
import com.ptteng.studyabroad.admin.service.TrainService;
import com.ptteng.studyabroad.util.DynamicUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * Train  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class TrainController {
	private static final Log log = LogFactory.getLog(TrainController.class);

	@Autowired
	private TrainService trainService;

	/**
	 * 1.搜索列表
	 * @param request
	 * @param response
	 * @param model
	 * @param page
	 * @param size
	 * @param language
	 * @param classType
	 * @param teacherType
	 * @param status
	 * @param startAt
	 * @param endAt
	 * @param week
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/class/search", method = RequestMethod.GET)
	public String getTrainList(HttpServletRequest request,
							   HttpServletResponse response, ModelMap model,
							   Integer page, Integer size, Integer language, Integer classType,
							   Integer teacherType, Integer status, Long startAt, Long endAt,
							   Integer week)
			throws Exception {

		log.info("get param is = page is : " + page + " size is : " + size + " language is : " + language + " classType is : " + classType
				+ " teacherType is : " + teacherType + " status is : " + status + " startAt is : " + startAt + " endAt is : " + endAt);

		if (page == null || page <= 0) {
			page = 1;
		}
		if (size == null || size <= 0) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		Map<String, Object> param = null;

		List<Long> trainIdList = null;

		List<Long> count = null;

		List<Train> trainList = null;

		param = DynamicUtil.getTrainList(language, classType, teacherType, status, startAt, endAt, week);
		try {

			trainIdList = trainService.getIdsByDynamicCondition(Train.class, param, start, size);
			if (DataUtils.isNullOrEmpty(trainIdList)) {
				log.error("get trainIdList is null！");
				model.addAttribute("code", -1000);
				return "common/fail";
			}
			log.info("get trainIdList is : " + trainIdList);

			count = trainService.getIdsByDynamicCondition(Train.class, param, 0, Integer.MAX_VALUE);
			if (DataUtils.isNullOrEmpty(count)) {
				log.error("get count is null！");
				model.addAttribute("code", -1000);
				return "common/fail";
			}
			log.info("get count is : " + count);

			trainList = trainService.getObjectsByIds(trainIdList);
			log.info("get trainList.size is" + trainList.size());

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get trainList error");
			model.addAttribute("code", -100000);
			return "common/fail";
		}

		model.addAttribute("code", "0");
		model.addAttribute("page", page);
		model.addAttribute("size", size);
		model.addAttribute("total", count.size());
		model.addAttribute("trainList", trainList);




		return "/studyabroad-home-service/train/json/trainListJson";
	}

	/**
	 * 2.详情
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/class/{id}", method = RequestMethod.GET)
	public String getTrainJson(HttpServletRequest request,
							   HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		if (DataUtils.isNullOrEmpty(id)) {
			log.error("get id is null！");
			model.addAttribute("code", -1000);
			return "common/fail";
		}
		log.info("get class id is : " + id);
		try {
			Train train = trainService.getObjectById(id);
			if (DataUtils.isNullOrEmpty(train)) {
				log.error("get train is null！");
				model.addAttribute("code", -1000);
				return "common/fail";
			}
			log.info("get train  is " + train);

			model.addAttribute("code", 0);

			model.addAttribute("train", train);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get train error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/studyabroad-home-service/train/json/trainDetailJson";
	}
	
	
	
	
}

