package com.ptteng.studyabroad.util;


import com.ptteng.common.dao.util.SQLUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.python.antlr.ast.Str;

import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;


public class DynamicUtil {

    private static final Log log = LogFactory.getLog(DynamicUtil.class);

    /**
     * 登录
     * @param name
     * @return
     */
    public static Map<String, Object> getLogin(String name) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("@query", "id");
        params.put("@table", "manager");
        params.put("name", "'" + name + "'");

        log.info(SQLUtil.convert2Sql(params, 0, Integer.MAX_VALUE));
        return params;
    }

    public static Map<String, Object> getManagerList(Integer rid,String name) {
        Map<String, Object> params = new HashMap<String, Object>();
//        params.put("@query", "m.id");
        params.put("@query", " distinct m.id");
        params.put("@table", "manager m,role r");
        params.put("m.rid", "r.id");
        params.put("@order", "m.createAt desc");
        if (DataUtils.isNotNullOrEmpty(name)) {

            params.put("m.name & like", "'%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(rid)) {
            params.put("m.rid", rid);

        }

        log.info(SQLUtil.convert2Sql(params, 0, Integer.MAX_VALUE));
        return params;
    }



    /**
     * Article搜索
     * @param title
     * @param author
     * @param createBy
     * @param status
     * @param startAt
     * @param endAt
     * @return
     */

    public static Map<String, Object> getArticleList(String title, String author, String createBy, Integer status, Long startAt, Long endAt) {
        Map<String, Object> param = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(title)) {
            param.put("a.title & like", "'%" + title + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(author)) {
            param.put("a.author & like", "'%" + author + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(createBy)) {
            param.put("m.name & like", "'%" + createBy + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            param.put("a.status", status);
        }
        if (DataUtils.isNotNullOrEmpty(startAt)) {
            param.put("a.createAt & >= ", startAt);
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            param.put("a.createAt & <= ", endAt);
        }
        param.put("a.createBy", "m.id");
        param.put("@order", "a.rank asc");
        param.put("@query", "a.id");
        param.put("@table", "article a,manager m");
        log.info(SQLUtil.convert2Sql(param,0, Integer.MAX_VALUE));
        return param;

    }

    /**
     * train搜索
     * @param language
     * @param classType
     * @param teacherType
     * @param status
     * @param startAt
     * @param endAt
     * @param week
     * @return
     */
    public static Map<String,Object> getTrainList(Integer language, Integer classType, Integer teacherType, Integer status, Long startAt, Long endAt, Integer week) {

        Map<String, Object> param = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(language)) {
            param.put("language", language);
        }
        if (DataUtils.isNotNullOrEmpty(classType)) {
            param.put("classType", classType);
        }
        if (DataUtils.isNotNullOrEmpty(teacherType)) {
            param.put("teacherType", teacherType);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            param.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty(startAt)) {
            param.put("startAt & >= ", startAt);
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            param.put("endAt & <= ", endAt);
        }
        if (DataUtils.isNotNullOrEmpty(week)) {
            param.put("week & like ", "'%" + week + "%'");
        }
        param.put("@order", "createAt desc");
        param.put("@query", "id");
        param.put("@table", "train");
        log.info(SQLUtil.convert2Sql(param, 0, Integer.MAX_VALUE));

        return param;
    }

    /**
     * 预约用户搜索
     * @param name
     * @param mobile
     * @param startAt
     * @param endAt
     * @return
     */
    public static Map<String,Object> getReserveUserList(String name, String mobile, Long startAt, Long endAt) {
        Map<String, Object> param = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(name)) {
            param.put("name & like ", "'%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(mobile)) {
            param.put("mobile & like ", "'%" + mobile + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(startAt)) {
            param.put("createAt & >= ", startAt);
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            param.put("createAt & <= ", endAt);
        }
        param.put("@order", "createAt desc");
        param.put("@query", "id");
        param.put("@table", "reserve_user");
        log.info(SQLUtil.convert2Sql(param,0,Integer.MAX_VALUE));
        return param;
    }
}
