package com.ptteng.studyabroad.controller;

import com.ptteng.studyabroad.admin.model.Train;
import com.ptteng.studyabroad.admin.service.TrainService;
import com.ptteng.studyabroad.util.CookieUtil;
import com.ptteng.studyabroad.util.DynamicUtil;
import com.ptteng.studyabroad.vo.TrainData;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * Train  crud
 * 1.新增
 * 2.删除
 * 3.修改
 * 4.详情
 * 5.列表
 * 6.上下线
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class TrainController {
    private static final Log log = LogFactory.getLog(TrainController.class);

    @Autowired
    private TrainService trainService;

    @Autowired
    private com.qding.common.util.http.cookie.CookieUtil cookieUtil;

    /**
     * 1.新增
     * @param request
     * @param response
     * @param model
     * @param train
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/class", method = RequestMethod.POST)
    public String addTrainJson(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model,
                                @RequestBody Train train) throws Exception {

        log.info("get train is : " + train);

        if (DataUtils.isNullOrEmpty(train.getClassType())) {
            log.info("必填参数:班级类型 有误或为空！");
            model.addAttribute("code", -9002);
            return "common/fail";
        }
        if (DataUtils.isNullOrEmpty(train.getTeacherType())) {
            log.info("必填参数:教师类型 有误或为空！");
            model.addAttribute("code", -9004);
            return "common/fail";
        }

        if (DataUtils.isNullOrEmpty(train.getLanguage())) {
            log.info("必填参数:语种类型 有误或为空！");
            model.addAttribute("code", -9005);
            return "common/fail";
        }

        if (DataUtils.isNullOrEmpty(train.getStartAt())) {
            log.info("必填参数:上课开始时间 有误或为空！");
            model.addAttribute("code", -9006);
            return "common/fail";
        }
        if (DataUtils.isNullOrEmpty(train.getEndAt())) {
            log.info("必填参数:上课结束时间 有误或为空！");
            model.addAttribute("code", -9007);
            return "common/fail";
        }

        Long adminId = Long.valueOf(cookieUtil.getKeyIdentity(request, com.qding.common.util.http.cookie.CookieUtil.USER_ID));
        log.info("get adminId is : " + adminId);

        train.setCreateBy(adminId);
        try {
            Long id = trainService.insert(train);
            log.info("insert train id is : " + id);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add train error ");
            model.addAttribute("code", -100000);
        }

        return "/data/json";
    }


    /**
     * 2.删除
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/class/{id}", method = RequestMethod.DELETE)
    public String deleteTrainJson(HttpServletRequest request,
                                  HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {
        if (DataUtils.isNullOrEmpty(id)) {
            log.error("get id is null！");
            model.addAttribute("code", -1000);
            return "common/fail";
        }
        log.info("delete train id is : " + id);
        try {
            boolean result = trainService.delete(id);

            log.info("delete train id result is : "+ result);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete train error,id is  " + id);
            model.addAttribute("code", -100000);

        }

        return "/data/json";
    }

    /**
     * 3.修改
     * @param request
     * @param response
     * @param model
     * @param train
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/class/{id}", method = RequestMethod.PUT)
    public String updateTrainJson(HttpServletRequest request,
                                  HttpServletResponse response, ModelMap model,
                                  @RequestBody Train train,
                                  @PathVariable Long id) throws Exception {

        if (DataUtils.isNullOrEmpty(id)) {
            log.error("get id is null！");
            model.addAttribute("code", -1000);
            return "common/fail";
        }
        log.info("update train is : " + train);

        if (DataUtils.isNullOrEmpty(train.getClassType())) {
            log.info("必填参数:班级类型 有误或为空！");
            model.addAttribute("code", -9002);
            return "common/fail";
        }
        if (DataUtils.isNullOrEmpty(train.getTeacherType())) {
            log.info("必填参数:教师类型 有误或为空！");
            model.addAttribute("code", -9004);
            return "common/fail";
        }

        if (DataUtils.isNullOrEmpty(train.getLanguage())) {
            log.info("必填参数:语种类型 有误或为空！");
            model.addAttribute("code", -9005);
            return "common/fail";
        }

        if (DataUtils.isNullOrEmpty(train.getStartAt())) {
            log.info("必填参数:上课开始时间 有误或为空！");
            model.addAttribute("code", -9006);
            return "common/fail";
        }
        if (DataUtils.isNullOrEmpty(train.getEndAt())) {
            log.info("必填参数:上课结束时间 有误或为空！");
            model.addAttribute("code", -9007);
            return "common/fail";
        }
        Long adminId = Long.valueOf(cookieUtil.getKeyIdentity(request, com.qding.common.util.http.cookie.CookieUtil.USER_ID));
        log.info("get adminId is :" + adminId);

        try {

            Train train1 = trainService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(train1)) {
                log.error("get train1 is null！");
                model.addAttribute("code", -1000);
                return "common/fail";
            }
            log.info("get train1 is :" + train1);

            train.setCreateAt(train1.getCreateAt());
            train.setCreateBy(train1.getCreateBy());
            train.setUpdateBy(adminId);
            train.setId(train1.getId());

            boolean result = trainService.update(train);

            log.info("update train result : " + result);

            model.addAttribute("code", 0);

            model.addAttribute("train", train);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update train error,id is  " + train.getId());
            model.addAttribute("code", -100000);

        }

        return "/data/json";
    }


    /**
     * 4.详情
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/class/{id}", method = RequestMethod.GET)
    public String getTrainJson(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {
        if (DataUtils.isNullOrEmpty(id)) {
            log.error("get id is null！");
            model.addAttribute("code", -1000);
            return "common/fail";
        }
        log.info("get train id is : " + id);
        try {
            Train train = trainService.getObjectById(id);
            log.info("get train  is : " + train);

            model.addAttribute("code", 0);

            model.addAttribute("train", train);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get train error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/studyabroad-admin-service/train/json/trainDetailJson";
    }

    /**
     * 5.搜索列表
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @param language
     * @param classType
     * @param teacherType
     * @param status
     * @param startAt
     * @param endAt
     * @param week
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/class/search", method = RequestMethod.GET)
    public String getTrainList(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model,
                                    Integer page, Integer size, Integer language, Integer classType,
                                    Integer teacherType, Integer status, Long startAt, Long endAt,
                                    Integer week)
            throws Exception {

        log.info("get param is = page is : " + page + " size is : " + size + " language is : " + language + " classType is : " + classType
                + " teacherType is : " + teacherType + " status is : " + status + " startAt is : " + startAt + " endAt is : " + endAt);

        if (page == null || page <= 0) {
            page = 1;
        }
        if (size == null || size <= 0) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        Map<String, Object> param = null;

        List<Long> trainIdList = null;

        List<Long> count = null;

        List<Train> trainList = null;

        param = DynamicUtil.getTrainList(language, classType, teacherType, status, startAt, endAt, week);
        try {

            trainIdList = trainService.getIdsByDynamicCondition(Train.class, param, start, size);
            if (DataUtils.isNullOrEmpty(trainIdList)) {
                log.error("get trainIdList is null！");
                model.addAttribute("code", -1000);
                return "common/fail";
            }
            log.info("get trainIdList is : " + trainIdList);

            count = trainService.getIdsByDynamicCondition(Train.class, param, 0, Integer.MAX_VALUE);
            if (DataUtils.isNullOrEmpty(count)) {
                log.error("get count is null！");
                model.addAttribute("code", -1000);
                return "common/fail";
            }
            log.info("get count is : " + count);

            trainList = trainService.getObjectsByIds(trainIdList);
            if (DataUtils.isNullOrEmpty(trainList)) {
                log.error("get trainList is null！");
                model.addAttribute("code", -1000);
                return "common/fail";
            }
            log.info("get trainList.size is : " + trainList.size());

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get trainList error ");
            model.addAttribute("code", -100000);
            return "common/fail";
        }

        model.addAttribute("code", "0");
        model.addAttribute("page", page);
        model.addAttribute("size", size);
        model.addAttribute("total", count.size());
        model.addAttribute("trainList", trainList);




        return "/studyabroad-admin-service/train/json/trainListJson";
    }


    /**
     * 6.上下线
     * @param request
     * @param response
     * @param model
     * @param train
     * @param id
     * @param status
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/class/status/{id}", method = RequestMethod.PUT)
    public String updatestatus(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model, Train train,
                               @PathVariable Long id, Integer status) throws Exception {

        if (DataUtils.isNullOrEmpty(id)) {
            log.error("get id is null！");
            model.addAttribute("code", -1000);
            return "common/fail";
        }

        log.info("get class id is : " + id + " status is : " + status);

        Long adminId = Long.valueOf(cookieUtil.getKeyIdentity(request, com.qding.common.util.http.cookie.CookieUtil.USER_ID));
        log.info("get adminId is : " + adminId);
        try {
            train = trainService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(train)) {
                log.error("get train is null！");
                model.addAttribute("code", -1000);
                return "common/fail";
            }
            log.info("get train  is " + train);

            train.setStatus(status);
            train.setUpdateBy(adminId);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get train error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        try {

            boolean result = trainService.update(train);

            model.addAttribute("code", 0);
            log.info("update status result is : " + result);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update train error,id is  " + train.getId());
            model.addAttribute("code", -100000);

        }

        return "/data/json";
    }


}

