package com.ptteng.studyabroad.controller;

import com.ptteng.studyabroad.admin.model.ReserveUser;
import com.ptteng.studyabroad.admin.service.ReserveUserService;
import com.ptteng.studyabroad.util.CookieUtil;
import com.ptteng.studyabroad.util.DynamicUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.python.antlr.ast.Str;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Result;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * ReserveUser  crud
 * 1.新增
 * 2.删除
 * 3.列表搜索
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class ReserveUserController {
	private static final Log log = LogFactory.getLog(ReserveUserController.class);

	@Autowired
	private ReserveUserService reserveUserService;

	@Autowired
	private com.qding.common.util.http.cookie.CookieUtil cookieUtil;

	/**
	 * 1.新增
	 * @param request
	 * @param response
	 * @param model
	 * @param reserveUser
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/reserve/user", method = RequestMethod.POST)
	public String addReserveUserJson(HttpServletRequest request,
									 HttpServletResponse response, ModelMap model, @RequestBody ReserveUser reserveUser) throws Exception {

		log.info("insert reserveUser is : " + reserveUser);


		if (DataUtils.isNullOrEmpty(reserveUser.getName())) {
			log.error("add reserveUser error ");
			model.addAttribute("code", -5007);
			return "common/fail";

		}
		if (DataUtils.isNullOrEmpty(reserveUser.getMobile())) {

			log.error("add reserveUser error ");
			model.addAttribute("code", -5023);
			return "common/fail";

		}

		Long adminId = Long.valueOf(cookieUtil.getKeyIdentity(request, com.qding.common.util.http.cookie.CookieUtil.USER_ID));
		log.info("get adminId is :" + adminId);

		try {
			reserveUser.setCreateBy(adminId);
			Long id = reserveUserService.insert(reserveUser);
			log.info("insert reserveUser is : "+id);
			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add reserveUser error ");
			model.addAttribute("code", -100000);
		}

		return "/data/json";
	}

	/**
	 * 2.删除
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/reserve/user/{id}", method = RequestMethod.DELETE)
	public String deleteReserveUserJson(HttpServletRequest request,
										HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete reserveUser id is :  " + id);
		if (DataUtils.isNullOrEmpty(id)) {
			log.error("get id is null！");
			model.addAttribute("code", -1000);
			return "common/fail";
		}

		try {
			boolean result = reserveUserService.delete(id);
			log.info("delete reserveUser result is : " + result);
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete reserveUser error,id is  " + id);
			model.addAttribute("code", -100000);

		}

		return "/data/json";
	}


	/**
	 * 3.搜索列表
	 * @param request
	 * @param response
	 * @param model
	 * @param page
	 * @param size
	 * @param name
	 * @param mobile
	 * @param startAt
	 * @param endAt
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/reserve/user/search", method = RequestMethod.GET)
	public String getMultiReserveUserJson(HttpServletRequest request,
										  HttpServletResponse response, ModelMap model,
										  Integer page,Integer size,String name,String mobile,
										  Long startAt,Long endAt)
			throws Exception {

		log.info("get param is = page is : " + page + " size is : " + size + " name is : " + name + " mobile is : " + mobile + " startAt is : " + startAt + " endAt is : :" + endAt);
		if (page == null || page <= 0) {
			page = 1;
		}
		if (size == null || size <= 0) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		Map<String, Object> reserveUserSql = null;

		List<Long> reserveUserIdList = null;

		List<Long> count = null;

		List<ReserveUser> reserveUserList = null;

		reserveUserSql = DynamicUtil.getReserveUserList(name, mobile, startAt, endAt);

		try {

			reserveUserIdList = reserveUserService.getIdsByDynamicCondition(ReserveUser.class, reserveUserSql, start, size);
			if (DataUtils.isNullOrEmpty(reserveUserIdList)) {
				log.error("get reserveUserIdList is null！");
				model.addAttribute("code", -1000);
				return "common/fail";
			}
			log.info("get reserveUserIdList is : " + reserveUserIdList);

			count = reserveUserService.getIdsByDynamicCondition(ReserveUser.class, reserveUserSql, 0, Integer.MAX_VALUE);
			if (DataUtils.isNullOrEmpty(count)) {
				log.error("get count is null！");
				model.addAttribute("code", -1000);
				return "common/fail";
			}
			log.info("get count is : " + count);

			reserveUserList = reserveUserService.getObjectsByIds(reserveUserIdList);
			if (DataUtils.isNullOrEmpty(reserveUserList)) {
				log.error("get reserveUserList is null！");
				model.addAttribute("code", -1000);
				return "common/fail";
			}
			log.info("get reserveUserList.size is" + reserveUserList.size());


			model.addAttribute("code", 0);
			model.addAttribute("total", count.size());
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("reserveUserList", reserveUserList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get reserveUser error,id is  " + reserveUserList);
			model.addAttribute("code", -100000);
		}

		return "/studyabroad-admin-service/reserveUser/json/reserveUserListJson";
	}

    /**
	 * 
	 * @param
	 * @return
	 */

	@RequestMapping(value = "/c/reserve/user", method = RequestMethod.GET)
	public String getreserveUserList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model) throws Exception {

		
		
		log.info("/reserveUser  to /reserveUser/view/reserveUserList");

		return "/studyabroad-admin-service/reserveUser/view/reserveUserList";
	}
    
    

    
	
	@RequestMapping(value = "/c/reserve/user/{id}", method = RequestMethod.GET)
	public String getReserveUser(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/reserveUser/" + id + "  to /reserveUser/view/reserveUserDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/studyabroad-admin-service/reserveUser/view/reserveUserDetail";
	}
	
	
	
	    
	

	@RequestMapping(value = "/a/reserve/user/{id}", method = RequestMethod.GET)
	public String getReserveUserJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			ReserveUser reserveUser = reserveUserService.getObjectById(id);
			log.info("get reserveUser data is " + reserveUser);

			model.addAttribute("code", 0);

			model.addAttribute("reserveUser", reserveUser);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get reserveUser error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/studyabroad-admin-service/reserveUser/json/reserveUserDetailJson";
	}

	@RequestMapping(value = "/a/reserve/user/{id}", method = RequestMethod.PUT)
	public String updateReserveUserJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, ReserveUser reserveUser) throws Exception {
		
		log.info("update reserveUser : reserveUser= " + reserveUser);
		
		try {
			
			reserveUserService.update(reserveUser);

			model.addAttribute("code", 0);

			model.addAttribute("reserveUser", reserveUser);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update reserveUser error,id is  " + reserveUser.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}


	

	
	
	
	
	
}

