package com.ptteng.studyabroad.controller;

import com.ptteng.common.storage.util.ImgStorageAliServiceImpl;
import com.ptteng.common.storage.util.ImgStorageUtil;
import com.ptteng.studyabroad.admin.model.Article;
import com.ptteng.studyabroad.admin.model.Manager;
import com.ptteng.studyabroad.admin.service.ArticleService;
import com.ptteng.studyabroad.admin.service.ManagerService;
import com.ptteng.studyabroad.util.CookieUtil;
import com.ptteng.studyabroad.util.DynamicUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.FileUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.lf5.LogLevel;
import org.python.antlr.ast.Str;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.persistence.Id;
import javax.rmi.CORBA.Util;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.crypto.Data;
import java.io.File;
import java.util.*;

//import static com.ptteng.studyabroad.admin.constant.Constant.ONLINE;
//import static com.ptteng.studyabroad.admin.constant.Constant.UN_ONLINE;

/**
 * Article  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class ArticleController {
    private static final Log log = LogFactory.getLog(ArticleController.class);

    @Autowired
    private ArticleService articleService;

    @Autowired
    private ImgStorageUtil imgStorageUtil;

    @Autowired
    private ManagerService managerService;


    @Autowired
    private com.qding.common.util.http.cookie.CookieUtil cookieUtil;


    /**
     * 1.新增
     * 2.删除
     * 3.修改
     * 4.搜索列表
     * 5.详情
     * 6.上下线
     * 7.上传图片
     * 8.拖动排序
     * @param
     * @return
     */


    /**
     * 1.新增
     *
     * @param request
     * @param response
     * @param model
     * @param article
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/article", method = RequestMethod.POST)
    public String addArticleJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model,
                                 @RequestBody Article article) throws Exception {

        log.info("insert  article is: " + article);
        if (DataUtils.isNullOrEmpty(article)) {
            log.error("get article is null！");
            model.addAttribute("code", -1000);
            return "common/fail";
        }
        if (DataUtils.isNullOrEmpty(article.getTitle())) {
            log.error("get title is null！");
            model.addAttribute("code", -1000);
            return "common/fail";
        }

        Long adminId = Long.valueOf(cookieUtil.getKeyIdentity(request, com.qding.common.util.http.cookie.CookieUtil.USER_ID));
        log.info("get adminId is : " + adminId);

        Long aId = null;
        try {
            article.setCreateBy(adminId);
            article.setId(null);

            aId = articleService.insert(article);
            log.info("insert article id is : " + aId);

            Integer articleId = new Long(aId).intValue();

            article.setId(aId);

            article.setRank((articleId));

            article.setCreateAt(System.currentTimeMillis());

            boolean result = articleService.update(article);
            log.info("update article rank result is :" + result);
            model.addAttribute("code", 0);
            log.info("update rank is :" + result);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add article error ");
            model.addAttribute("code", -6002);
        }

        return "/data/json";
    }

    /**
     * 2.删除
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/article/{id}", method = RequestMethod.DELETE)
    public String deleteArticleJson(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete article : id= " + id);
        if (DataUtils.isNullOrEmpty(id)) {
            log.error("get id is null！");
            model.addAttribute("code", -1000);
            return "common/fail";
        }
        try {
            boolean result = articleService.delete(id);

            log.info("delete article result is :" + result);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete article error,id is  " + id);
            model.addAttribute("code", -6004);

        }

        return "/data/json";
    }

    /**
     * 3.修改
     *
     * @param request
     * @param response
     * @param model
     * @param article
     * @return
     * @throws Exception
     */

    @RequestMapping(value = "/a/u/article/", method = RequestMethod.PUT)
    public String updateArticle(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                @RequestBody Article article) {
        log.info("param article : " + article);
        if (DataUtils.isNullOrEmpty(article)) {
            log.error("get article is null！");
            model.addAttribute("code", -1000);
            return "common/fail";
        }
        if (DataUtils.isNullOrEmpty(article.getId())) {
            log.error("get id is null！");
            model.addAttribute("code", -1000);
            return "common/fail";
        }

        Long adminId = Long.valueOf(cookieUtil.getKeyIdentity(request, com.qding.common.util.http.cookie.CookieUtil.USER_ID));
        log.info("get adminId is : " + adminId);

        article.setUpdateBy(adminId);
        log.info("update article is :" + article);
        try {

            boolean result = articleService.update(article);
            log.info("update article result is :" + result);
            model.addAttribute("code", 0);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update article error,id is  " + article.getId());
            model.addAttribute("code", -6003);
        }

        return "/data/json";


    }


//    @RequestMapping(value = "/a/u/article/{id}", method = RequestMethod.PUT)
//    public String updateArticleJson(HttpServletRequest request,
//                                    HttpServletResponse response, ModelMap model,
//                                    @RequestBody Article article, @PathVariable Long id) throws Exception {
//
//        log.info("param article : article= " + article);
//
//        if (DataUtils.isNullOrEmpty(id)) {
//            log.error("get id is null！");
//            model.addAttribute("code", -1000);
//            return "common/fail";
//        }
//        if (DataUtils.isNullOrEmpty(article)) {
//            log.error("get article is null！");
//            model.addAttribute("code", -1000);
//            return "common/fail";
//        }
//
//        Long adminId = Long.valueOf(cookieUtil.getKeyIdentity(request, com.qding.common.util.http.cookie.CookieUtil.USER_ID));
//        log.info("get adminId is : " + adminId);
//
//        try {
//
//            Article article1 = articleService.getObjectById(id);
//            if (DataUtils.isNullOrEmpty(article1)) {
//                log.error("get article1 is null！");
//                model.addAttribute("code", -1000);
//                return "common/fail";
//            }
//            log.info("get article1 is :" + article1);
//
//            article.setCreateBy(article1.getCreateBy());
//            article.setUpdateBy(adminId);
//            article.setRank(article1.getRank());
//            article.setCreateAt(article1.getCreateAt());
//            article.setId(article1.getId());
//
//            log.info("update article is :" + article);
//            boolean result = articleService.update(article);
//
//            log.info("update article result is :" + result);
//
//            model.addAttribute("code", 0);
//
//
//        } catch (Throwable t) {
//            t.printStackTrace();
//            log.error(t.getMessage());
//            log.error("update article error,id is  " + article.getId());
//            model.addAttribute("code", -6003);
//
//        }
//
//        return "/data/json";
//    }

    /**
     * 4.搜索列表
     *
     * @param request
     * @param response
     * @param model
     * @param title
     * @param author
     * @param createBy
     * @param status
     * @param startAt
     * @param endAt
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/article/search", method = RequestMethod.GET)
    public String getarticleList(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model,
                                 String title, String author, String createBy,
                                 Integer status, Long startAt, Long endAt,
                                 Integer page, Integer size
    ) throws Exception {

        log.info("param is = title is :" + title + " author is :" + author + " createBy is :"
                + createBy + " status is :" + status + " startAt is :" + startAt + " endAt is "
                + endAt + " page is :" + page + " size:" + size);
        if (page == null || page <= 0) {
            page = 1;
        }
        if (size == null || size <= 0) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        List<Long> articelIdList = null;

        List<Long> count = null;

        List<Article> articleList = null;

        Map<String, Object> param = null;

        HashSet<Long> createByIdList = new HashSet<>();

        List<Long> managerIdList = new ArrayList<>();

        List<Manager> managerList = null;

        List<Map<String, Object>> articleDataList = new ArrayList<>();


        param = DynamicUtil.getArticleList(title, author, createBy, status, startAt, endAt);

        try {


            articelIdList = articleService.getIdsByDynamicCondition(Article.class, param, start, size);
            log.info("get articleIdList is" + articelIdList);
            if (DataUtils.isNullOrEmpty(articelIdList)) {
                log.error("get articleIdList is null！");
                model.addAttribute("code", -1000);
                return "common/fail";
            }

            count = articleService.getIdsByDynamicCondition(Article.class, param, 0, Integer.MAX_VALUE);
            log.info("get count is:" + count);
            if (DataUtils.isNullOrEmpty(count)) {
                log.error("get count is null！");
                model.addAttribute("code", -1000);
                return "common/fail";
            }

            articleList = articleService.getObjectsByIds(articelIdList);
            if (DataUtils.isNullOrEmpty(articleList)) {
                log.error("get articleList is null！");
                model.addAttribute("code", -1000);
                return "common/fail";
            }
            log.info("get articleList.size is:" + articleList.size());


            for (Article a : articleList) {
                Long id = a.getCreateBy();
                createByIdList.add(id);
            }

            managerIdList.addAll(createByIdList);
            log.info("get managerIdList is: " + managerIdList);

            managerList = managerService.getObjectsByIds(managerIdList);

            for (Article a : articleList) {
                for (Manager m : managerList) {
                    if (a.getCreateBy().equals(m.getId())) {
                        Map<String, Object> articleData = new HashMap<>();
                        articleData.put("id", a.getId());
                        articleData.put("createBy", m.getCreateBy());
                        articleData.put("managerName", m.getName());
                        articleData.put("rank", a.getRank());
                        articleData.put("title", a.getTitle());
                        articleData.put("author", a.getAuthor());
                        articleData.put("url", a.getUrl());
                        articleData.put("img", a.getImg());
                        articleData.put("summary", a.getSummary());
                        articleData.put("content", a.getContent());
                        articleData.put("status", a.getStatus());
                        articleData.put("createAt", a.getCreateAt());
                        articleDataList.add(articleData);
                    }
                }
            }


                model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", count.size());
            model.addAttribute("articleList", articleDataList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get articleList error");
            model.addAttribute("code", -100000);
            return "common/fail";
        }


        return "/studyabroad-admin-service/article/json/articleListJson";
    }

    /**
     * 5、详情
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/article/{id}", method = RequestMethod.GET)
    public String getArticleJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get Article : id= " + id);
        if (DataUtils.isNullOrEmpty(id)) {
            log.error("get id is null！");
            model.addAttribute("code", -1000);
            return "common/fail";
        }
        try {
            Article article = articleService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(article)) {
                log.error("get article is null！");
                model.addAttribute("code", -1000);
                return "common/fail";
            }
            log.info("get article data is " + article);

            model.addAttribute("code", 0);

            model.addAttribute("article", article);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get article error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/studyabroad-admin-service/article/json/articleDetailJson";
    }

    /**
     * 6.上下线
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @param status
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/article/status/{id}", method = RequestMethod.PUT)
    public String updateStatus(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model,
                               @PathVariable Long id, Integer status)
            throws Exception {


        log.info("get article id is: " + id + " status is :" + status);



        if (DataUtils.isNullOrEmpty(status)) {
            log.error("get status is null！");
            model.addAttribute("code", -1000);
            return "common/fail";
        }
        if (DataUtils.isNullOrEmpty(id)) {
            model.addAttribute("code", -3001);
            log.error("get id error:" + id);
            return "common/fail";
        }

        Article article = articleService.getObjectById(id);
        if (DataUtils.isNullOrEmpty(article)) {
            log.error("get article is null！");
            model.addAttribute("code", -1000);
            return "common/fail";
        }
        log.info("get article is :" + article);

        Long adminId = Long.valueOf(cookieUtil.getKeyIdentity(request, com.qding.common.util.http.cookie.CookieUtil.USER_ID));
        log.info("get adminId is : " + adminId);

//        if (status == ONLINE) {
//            status = ONLINE;
//        } else {
//            status = UN_ONLINE;
//        }
        article.setStatus(status);
        article.setUpdateBy(adminId);
        try {

            boolean result = articleService.update(article);
            log.info("update article result is :" + result);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error("update artcle status error");
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
            return "common/fail";
        }

        model.addAttribute("code", 0);

        return "/data/json";

    }

    /**
     * 7.上传图片
     *
     * @param request
     * @param response
     * @param model
     * @param file
     * @param module
     * @return
     * @throws Exception
     */

    @RequestMapping(value = "/a/u/img/{module}", method = RequestMethod.POST)
    public String uploadFile(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                             @RequestParam MultipartFile file, @PathVariable String module) {

        log.info("upload module is " + module);

        if (org.apache.commons.lang.StringUtils.isBlank(module)) {
            log.info("type is null");
        }

        log.info(file.getOriginalFilename());

        try {

            String ext = FileUtil.getFileExtension(file.getOriginalFilename());

            String fileName = UUID.randomUUID().toString() + "." + ext;


//            String filePath = "/data/img/graship/" + module + "/" + fileName;

            String filePath = "/Users/shun/Desktop/img/" + module + "/" + fileName;

//            String dirPath = "/data/img/graship/" + module;
            String dirPath = "/Users/shun/Desktop/img/" + module;


//            File dir = new File("/data/img/graship/" + module);
            File dir = new File("/Users/shun/Desktop/img/" + module);

            if (dir.exists()) {
                log.info("创建目录" + dirPath + "失败，目标目录已经存在");
            } else {
                //创建目录
                if (dir.mkdirs()) {
                    log.info("创建目录" + dirPath + "成功！");
                } else {
                    log.info("创建目录" + dirPath + "失败！");
                }
            }

            File tempFile = new File(filePath);
            file.transferTo(tempFile);
            String url = this.imgStorageUtil.imgStorage(null, "img/" + module + "/"
//            String url = this.imgStorageUtil.imgStorage(null, "graship/" + module + "/"
                    + fileName, filePath);
            log.info(module + " upload success ,and file name is " + fileName
                    + "temp path is " + filePath + " access url is " + url);
            tempFile.delete();
//			log.info(file.getOriginalFilename() + " delete success ");
            model.addAttribute("url", url);
            model.addAttribute("code", "0");

            return "/common/img";

        } catch (Throwable t) {

            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/common/success";
    }

    /**
     * 8.Article拖动排序
     *
     * @param request
     * @param response
     * @param model
     * @param rank
     * @return
     * @throws Exception
     */
    //保存排序,前端传一数组过来,里面包含的是拖动后的id排序,比如传[3.7.8.1.9]即表示排第一的是id为3的记录,第二的是id为7的,类推
    @RequestMapping(value = "/a/u/article/rank", method = RequestMethod.PUT)
    public String sort(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                       Long[] rank) throws Exception {


        if (rank == null || rank.length == 0) {
            log.error("get rank is null！");
            model.addAttribute("code", -1000);
            return "common/fail";

        }
        List<Long> list = Arrays.asList(rank);
        log.info("拖动后的rank排序：" + list);
        try {
            List<Article> articleList = articleService.getObjectsByIds(list);
            if (DataUtils.isNullOrEmpty(articleList)) {
                log.error("get articleList is null！");
                model.addAttribute("code", -1000);
                return "common/fail";
            }
            //循环后自增
            int index = 1;
            for (Article article : articleList) {
                article.setRank(index);
                index += 1;
            }
            boolean result = articleService.updateList(articleList);
            log.info("update rank result is :" + result);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error("update rank error:");
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
            return "common/fail";
        }
        return "common/success";
    }


}

