/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.score.home.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.score.home.model.Star;
import com.ptteng.score.home.service.StarService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StarServiceImpl
extends BaseDaoServiceImpl
implements StarService {
    private static final Log log = LogFactory.getLog(StarServiceImpl.class);

    public Long insert(Star star) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + star));
        if (star == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        star.setCreateAt(Long.valueOf(currentTimeMillis));
        star.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)star);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + star));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Star> insertList(List<Star> starList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (starList == null ? "null" : Integer.valueOf(starList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(starList)) {
            return new ArrayList<Star>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Star star : starList) {
            star.setCreateAt(Long.valueOf(currentTimeMillis));
            star.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(starList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + starList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Star.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Star star) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (star == null ? "null" : star.getId())));
        boolean result = false;
        if (star == null) {
            return true;
        }
        star.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)star);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + star));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + star));
        }
        return result;
    }

    public boolean updateList(List<Star> starList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (starList == null ? "null" : Integer.valueOf(starList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(starList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Star star : starList) {
            star.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(starList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + starList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + starList.size()));
        return result;
    }

    public Star getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Star star = null;
        if (id == null) {
            return star;
        }
        try {
            star = (Star)this.dao.get(Star.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return star;
    }

    public List<Star> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List star = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Star>();
        }
        try {
            star = this.dao.getList(Star.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (star == null ? "null" : Integer.valueOf(star.size()))));
        return star;
    }

    public List<Long> getStarIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStarIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countStarIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getStarIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getStarIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

