package com.ptteng.score.admin.util;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.score.home.model.Manager;
import com.ptteng.score.home.service.ManagerService;
import com.ptteng.score.home.service.StaffService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;

@Component
public class ScoreUserUtil {

    @Autowired
    private CookieUtil cookieUtil;

    @Autowired
    private ManagerService managerService;

    @Autowired
    private StaffService staffService;

    public static ScoreUserUtil scoreUserUtil;

    @PostConstruct
    public void init() {
        scoreUserUtil = this;
    }

    public static Long getManagerIdLongValue(HttpServletRequest request) {

        Long userIdLong = 0L;

        String userIdStr = scoreUserUtil.cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);

        if (DataUtils.isNotNullOrEmpty(userIdStr)) {

            return Long.valueOf(userIdStr);

        } else if (DataUtils.isNullOrEmpty(userIdStr)) {

            Manager user = (Manager) request.getAttribute("user");

            return user.getId();
        }


        return userIdLong;
    }


    public static Manager getAdminManager(HttpServletRequest request) throws ServiceException, ServiceDaoException {

        Long userIdLongValue = getManagerIdLongValue(request);

        Manager manager = scoreUserUtil.managerService.getObjectById(userIdLongValue);

        return manager;

    }



}
