package com.ptteng.score.admin.controller;

import com.ptteng.score.admin.util.DynamicSQLUtil;
import com.ptteng.score.admin.util.LogUtil;
import com.ptteng.score.home.model.DailyAttendance;
import com.ptteng.score.home.model.Tenant;
import com.ptteng.score.home.service.DailyAttendanceService;
import com.ptteng.score.home.service.TenantService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * Tenant  crud
 */
@Controller
public class TenantController {
    private static final Log log = LogFactory.getLog(TenantController.class);

    @Autowired
    private TenantService tenantService;

    @Autowired
    private CookieUtil cookieUtil;
    @Autowired
    private DailyAttendanceService dailyAttendanceService;

    //1 新增租户
    @RequestMapping(value = "/a/u/tenant", method = RequestMethod.POST)
    public String addTenantJson(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, Tenant tenant) throws Exception {

        log.info("add tenant : tenant= " + tenant);
        //参数校验
        if (tenant.getName() == null) {
            model.addAttribute("code", -11000);
            log.info("name is null");
            return "/common/fail";
        }

        if (tenant.getType() == null) {
            model.addAttribute("code", -11003);
            log.info("type is null");
            return "/common/fail";
        }
        if (tenant.getStatus() == null) {
            model.addAttribute("code", -11004);
            log.info("status is null");
            return "/common/fail";
        }


        try {
            tenant.setId(null);
            Long userId = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));
            tenant.setCreateBy(userId);
            tenant.setUpdateBy(userId);

            Long id = tenantService.insert(tenant);

            // 新建 签到、爱心点赞、工作日志
            DailyAttendance da1 = new DailyAttendance();
            da1.setApplyManageId(1L);

            DailyAttendance da2 = new DailyAttendance();
            da2.setApplyManageId(2L);

            DailyAttendance da3 = new DailyAttendance();
            da3.setApplyManageId(3L);




            if (DataUtils.isNullOrEmpty(id)) {
                log.info("add tenant  error ");
                model.addAttribute("code", -1);
                return "/common/fail";
            }

            model.addAttribute("code", 0);
            model.addAttribute("id", id);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add tenant error ");
            model.addAttribute("code", -1);
        }

        return "/common/postSuccess";
    }


    //2 获取租户详情
    @RequestMapping(value = "/a/u/tenant/{id}", method = RequestMethod.GET)
    public String getTenantJson(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get data : id= " + id);
        try {
            Tenant tenant = tenantService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(tenant)) {
                log.info("get tenant error ");
                model.addAttribute("code", -11005);
                return "/common/fail";
            } else {
                log.info("get tenant data is " + tenant);
            }

            model.addAttribute("code", 0);
            model.addAttribute("tenant", tenant);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get tenant error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/json/tenant/json/tenantDetailJson";
    }

    // 3 修改租户
    @RequestMapping(value = "/a/u/tenant/{id}", method = RequestMethod.PUT)
    public String updateTenantJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, Tenant tenant, @PathVariable Long id) throws Exception {

        log.info("update tenant : tenant= " + tenant);

        if (id == null) {
            model.addAttribute("code", -11006);
            log.info("id is null");
            return "/common/fail";
        }
        if (tenant.getName() == null) {
            model.addAttribute("code", -11000);
            log.info("name is null");
            return "/common/fail";
        }

        if (tenant.getType() == null) {
            model.addAttribute("code", -11003);
            log.info("type is null");
            return "/common/fail";
        }
        if (tenant.getStatus() == null) {
            model.addAttribute("code", -11004);
            log.info("status is null");
            return "/common/fail";
        }
        Long userId = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));

        Tenant oldTenant = tenantService.getObjectById(id);
        if (DataUtils.isNullOrEmpty(oldTenant)) {
            log.info("get tenant error ");
            model.addAttribute("code", -11005);
            return "/common/fail";
        } else {
            log.info("get oldTenant data is " + oldTenant);
        }
        tenant.setUpdateBy(userId);

        try {

            Boolean isUpdate = tenantService.update(tenant);
            if (isUpdate) {
                log.info(" update success.");
            } else {
                model.addAttribute("code", -1);
                return "/common/fail";
            }
            model.addAttribute("code", 0);
            model.addAttribute("tenant", tenant);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update tenant error,id is  " + tenant.getId());
            model.addAttribute("code", -6003);

        }
        return "/common/success";
    }


    // 4 停用/启用租户
    @RequestMapping(value = "/a/u/tenant/{id}/status/{status}", method = RequestMethod.PUT)
    public String updateTenantJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model,
                                   @PathVariable Long id, @PathVariable Integer status
    ) throws Exception {

        log.info("tenant id is: " + id + ". status is: " + status);

        if (id == null) {
            model.addAttribute("code", -11006);
            log.info("id is null");
            return "/common/fail";
        }

        if (status == null) {
            model.addAttribute("code", -11004);
            log.info("status is null");
            return "/common/fail";
        }

        try {

            Tenant tenant = tenantService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(tenant)) {
                log.info("get tenant error ");
                model.addAttribute("code", -11005);
                return "/common/fail";
            } else {
                log.info("get tenant data is " + tenant);
            }

            if (status.equals(tenant.getStatus())) {
                model.addAttribute("code", -11007);
                return "/common/fail";
            } else {
                log.info("tenant status is different from database");
            }

            tenant.setStatus(status);
            Boolean isUpdate = tenantService.update(tenant);
            if (isUpdate) {
                log.info(" update success.");
            } else {
                model.addAttribute("code", -1);
                return "/common/fail";
            }

            model.addAttribute("code", 0);
            model.addAttribute("tenant", tenant);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update tenant error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/data/json";
    }


    //5 获取租户列表
    @RequestMapping(value = "/a/u/tenant/search", method = RequestMethod.GET)
    public String getMultiTenantJson(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, Integer page, Integer size,
                                     String name,  Integer type, Integer status,
                                     String phone, String nick, String province, String city,
                                     Long createStartAt, Long createEndAt)
            throws Exception {

        //打印入参
        log.info("============================================");
        String paramStr = LogUtil.convertParam("/a/u/tenant/search  by==name", name,  "type", type, "status", status,
                "phone", phone, "nick", nick, "province", province, "city", city,
                "createStartAt", createStartAt, "createEndAt", createEndAt, "page", page, "size", size);
        log.info(paramStr);

        //初始化page size start
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        String pageStr = LogUtil.convertParam("page", page, "start", start, "size", size);
        log.info(pageStr);


        try {
            //动态查询-获取参数列表

            Map<String, Object> param = DynamicSQLUtil.getTenantList(name, type, status, phone, nick, province, city, createStartAt, createEndAt);
            log.info(" param size =  " + param.size());

            //获取list
            List<Long> idList = tenantService.getIdsByDynamicCondition(Tenant.class, param, start, size);
            if (CollectionUtils.isEmpty(idList)) {
                log.info(" idList is null ");
            } else {
                log.info(" idList size =  " + idList.size());
            }
            List<Tenant> tenantList = tenantService.getObjectsByIds(idList);
            log.info("tenantList size = " + tenantList.size());

            //获取total
            List<Long> count = tenantService.getIdsByDynamicCondition(Tenant.class, param, 0, Integer.MAX_VALUE);

            model.addAttribute("code", 0);
            model.addAttribute("size", tenantList.size());
            model.addAttribute("total", count.size());
            model.addAttribute("tenantList", tenantList);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get tenant error,page is " + page + " , size " + size);
            model.addAttribute("code", -1);
        }

        return "/json/tenant/json/tenantListJson";
    }

    // 6 批量删除租户
    @RequestMapping(value = "/a/u/tenant", method = RequestMethod.DELETE)
    public String deleteTenantJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, Long[] tids)
            throws Exception {

        if (DataUtils.isNullOrEmpty(tids)) {
            model.addAttribute("code", -11006);
            return "/common/fail";
        }
        List<Long> list = Arrays.asList(tids);
        log.info("delete  : list= " + list);

        //判断状态，使用中无法删除
        List<Tenant> tenantList = tenantService.getObjectsByIds(list);
        int tenantSize = tenantList.size();
        log.info("tenantList size = " + tenantSize);
        for (int n = 0; n < tenantSize; n++) {
            Tenant tenant = tenantList.get(n);
            if (tenant.getStatus().equals(Tenant.TYPE_OFFICIAL)) {
                model.addAttribute("code", -11008);
                return "/common/fail";
            }
        }

        try {
            tenantService.deleteList(Tenant.class, list);
            log.info("delete tenant success");
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete tenant error,list is  " + list);
            model.addAttribute("code", -6004);
        }

        return "/data/json";
    }
}

