-- ----------------------------
-- Table structure for `user`
-- ----------------------------
-- DROP TABLE IF EXISTS `user`;
CREATE TABLE `user` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `nick` varchar(10)    COMMENT '昵称',  
    `sex` tinyint    COMMENT '性别：0=未知，1=女，2=男',  
    `avatar` varchar(100)    COMMENT '头像',  
    `permanent_address` varchar(30)    COMMENT '常住地',  
    `lessee_orders` int(20)    COMMENT '承租人下单数量（正常结束订单数量）',  
    `lessor_orders` int(20)    COMMENT '出租人接单数量（正常结束订单数量）',  
    `mobile` varchar(15)    COMMENT '手机号',  
    `open_id` varchar(30)    COMMENT '微信openID',  
    `user_type` tinyint(2)    COMMENT '用户身份：0=未知，1=承租人，2=出租人',  
    `recommender_id` bigint    COMMENT '推荐人ID',  
    `age` bigint    COMMENT '年龄',  
    `height` int(20)    COMMENT '身高',  
    `hobby` varchar(100)    COMMENT '兴趣爱好',  
    `schedule` varchar(10)    COMMENT '档期',  
    `we_chat` varchar(30)    COMMENT '微信号',  
    `toll` varchar(10)    COMMENT '出租人收费',  
    `video_url` varchar(100)    COMMENT '出租人视频链接',  
    `img_url` varchar(600)    COMMENT '出租人图片链接',  
    `positioning` varchar(10)    COMMENT '当前定位',  
    `tag` varchar(50)    COMMENT '出租人技能标签',  
    `fee_cap` varchar(10)    COMMENT '收费上限',  
    `name` varchar(10)    COMMENT '姓名',  
    `id_number` varchar(20)    COMMENT '身份证号',  
    `user_status` tinyint    COMMENT '用户状态：0=未知，1=注册，2.授权，3=实名',  
    `login_status` tinyint    COMMENT '登录状态：0=未知，1=未登录，2=登录',  
    `status` tinyint    COMMENT '用户账号状态：0=未知，1=正常，2=冻结',  
    `orders_status` tinyint    COMMENT '订单状态变更红点',  
    `new_orders` int(20)    COMMENT '新订单数量',  
    `create_by` bigint    COMMENT '创建人ID',  
    `update_by` bigint    COMMENT '更新人ID',  
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',  
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;





