-- ----------------------------
-- Table structure for `user`
-- ----------------------------
-- DROP TABLE IF EXISTS `user`;
CREATE TABLE `user` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `nick` varchar(10)    COMMENT '昵称',  
    `sex` tinyint    COMMENT '性别：0=未知，1=女，2=男',  
    `avatar` varchar(100)    COMMENT '头像',  
    `permanent_address` varchar(30)    COMMENT '常住地',  
    `lessee_orders` int(20)    COMMENT '承租人下单数量（正常结束订单数量）',  
    `lessor_orders` int(20)    COMMENT '出租人接单数量（正常结束订单数量）',  
    `mobile` varchar(15)    COMMENT '手机号',  
    `open_id` varchar(30)    COMMENT '微信openID',  
    `user_type` tinyint(2)    COMMENT '用户身份：0=未知，1=承租人，2=出租人',  
    `recommender_id` bigint    COMMENT '推荐人ID',  
    `age` bigint    COMMENT '年龄',  
    `height` int(20)    COMMENT '身高',  
    `hobby` varchar(100)    COMMENT '兴趣爱好',  
    `schedule` varchar(10)    COMMENT '档期',  
    `we_chat` varchar(30)    COMMENT '微信号',  
    `toll` varchar(10)    COMMENT '出租人收费',  
    `video_url` varchar(100)    COMMENT '出租人视频链接',  
    `img_url` varchar(600)    COMMENT '出租人图片链接',  
    `positioning` varchar(10)    COMMENT '当前定位',  
    `tag` varchar(50)    COMMENT '出租人技能标签',  
    `fee_cap` varchar(10)    COMMENT '收费上限',  
    `name` varchar(10)    COMMENT '姓名',  
    `id_number` varchar(20)    COMMENT '身份证号',  
    `user_status` tinyint    COMMENT '用户状态：0=未知，1=注册，2.授权，3=实名',  
    `login_status` tinyint    COMMENT '登录状态：0=未知，1=未登录，2=登录',  
    `status` tinyint    COMMENT '用户账号状态：0=未知，1=正常，2=冻结',  
    `orders_status` tinyint    COMMENT '订单状态变更红点',  
    `new_orders` int(20)    COMMENT '新订单数量',  
    `create_by` bigint    COMMENT '创建人ID',  
    `update_by` bigint    COMMENT '更新人ID',  
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',  
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `user_comment_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_comment_relation`;
CREATE TABLE `user_comment_relation` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `lessee_id` bigint NOT NULL   COMMENT '承租人ID',  
    `lessor_id` bigint NOT NULL   COMMENT '出租人ID',  
    `comment` varchar(50) NOT NULL   COMMENT '评论',  
    `create_by` bigint    COMMENT '创建人ID',  
    `update_by` bigint    COMMENT '更新人ID',  
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',  
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `orders`
-- ----------------------------
-- DROP TABLE IF EXISTS `orders`;
CREATE TABLE `orders` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `lessee_id` bigint NOT NULL   COMMENT '承租人ID',  
    `lessor_id` bigint NOT NULL   COMMENT '出租人ID',  
    `lease_start_at` bigint NOT NULL   COMMENT '租赁开始时间',  
    `lease_end_at` bigint NOT NULL   COMMENT '租赁结束时间',  
    `price` varchar(10) NOT NULL   COMMENT '订单价格',  
    `total_price` varchar(10) NOT NULL   COMMENT '总支付金额（订单价格+服务费）',  
    `lessee_message` varchar(100)    COMMENT '承租人留言',  
    `lessor_message` varchar(100)    COMMENT '出租人留言',  
    `pay_at` bigint NOT NULL   COMMENT '支付时间',  
    `pay_status` tinyint NOT NULL   COMMENT '支付状态：1=支付成功，2=支付失败',  
    `status` tinyint NOT NULL   COMMENT '订单状态：见model注释或者接口文档约定',  
    `refund_at` bigint    COMMENT '退款时间',  
    `order_no` varchar(30) NOT NULL   COMMENT '订单号',  
    `create_by` bigint    COMMENT '创建人ID',  
    `update_by` bigint    COMMENT '更新人ID',  
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',  
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `user_manager_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_manager_relation`;
CREATE TABLE `user_manager_relation` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `lessor_id` bigint NOT NULL   COMMENT '出租人ID',  
    `create_by` bigint    COMMENT '创建人ID',  
    `update_by` bigint    COMMENT '更新人ID',  
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',  
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `withdraw`
-- ----------------------------
-- DROP TABLE IF EXISTS `withdraw`;
CREATE TABLE `withdraw` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `bank_card_number` varchar(30) NOT NULL   COMMENT '银行卡号',  
    `issuing_bank` varchar(30) NOT NULL   COMMENT '发卡银行',  
    `bank_card_owner_name` varchar(20) NOT NULL   COMMENT '持卡人姓名',  
    `withdrawal_amount` varchar(20) NOT NULL   COMMENT '提现金额',  
    `create_by` bigint    COMMENT '创建人',  
    `update_by` bigint    COMMENT '更新人',  
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',  
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `user_comment_count`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_comment_count`;
CREATE TABLE `user_comment_count` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `uid` bigint NOT NULL   COMMENT '用户ID',  
    `field1` int    COMMENT '与资料符合',  
    `field2` int    COMMENT '态度非常好',  
    `field3` int    COMMENT '幽默',  
    `field4` int    COMMENT '形象佳',  
    `field5` int    COMMENT '漂亮有气质',  
    `field6` int    COMMENT '健谈',  
    `field7` int    COMMENT '准时',  
    `field8` int    COMMENT '相处愉快',  
    `field9` int    COMMENT '迟到',  
    `field10` int    COMMENT '与资料不符',  
    `field11` int    COMMENT '一直玩手机',  
    `field12` int    COMMENT '提前离开',  
    `create_by` bigint    COMMENT '创建时间',  
    `update_by` bigint    COMMENT '更新时间',  
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',  
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;





