package com.ptteng.rent.user.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.rent.user.model.Withdraw;
import com.ptteng.rent.user.service.WithdrawService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class WithdrawServiceImpl extends BaseDaoServiceImpl implements WithdrawService {

 

	private static final Log log = LogFactory.getLog(WithdrawServiceImpl.class);



		   
		@Override
		public Long insert(Withdraw withdraw)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + withdraw);

		if (withdraw == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		withdraw.setCreateAt(currentTimeMillis);
		withdraw.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(withdraw);
		} catch (DaoException e) {
			log.error(" insert wrong : " + withdraw);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Withdraw> insertList(List<Withdraw> withdrawList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (withdrawList == null ? "null" : withdrawList.size()));
      
		List<Withdraw> resultList = null;

		if (CollectionUtils.isEmpty(withdrawList)) {
			return new ArrayList<Withdraw>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Withdraw withdraw : withdrawList) {
			withdraw.setCreateAt(currentTimeMillis);
			withdraw.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Withdraw>) dao.batchSave(withdrawList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + withdrawList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Withdraw.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Withdraw withdraw)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (withdraw == null ? "null" : withdraw.getId()));

		boolean result = false;

		if (withdraw == null) {
			return true;
		}

		withdraw.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(withdraw);
		} catch (DaoException e) {
			log.error(" update wrong : " + withdraw);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + withdraw);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Withdraw> withdrawList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (withdrawList == null ? "null" : withdrawList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(withdrawList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Withdraw withdraw : withdrawList) {
			withdraw.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(withdrawList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + withdrawList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + withdrawList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Withdraw getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Withdraw withdraw = null;

		if (id == null) {
			return withdraw;
		}

		try {
			withdraw = (Withdraw) dao.get(Withdraw.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return withdraw;		
		}	
		  
    	   
		@Override
		public List<Withdraw> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Withdraw> withdraw = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Withdraw>();
		}

		try {
			withdraw = (List<Withdraw>) dao.getList(Withdraw.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (withdraw == null ? "null" : withdraw.size()));
    
		return withdraw;	
		}	
		  
    	
		
	
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getWithdrawIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getWithdrawIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countWithdrawIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getWithdrawIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getWithdrawIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

