package com.ptteng.rent.user.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.rent.user.model.UserManagerRelation;
import com.ptteng.rent.user.service.UserManagerRelationService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class UserManagerRelationServiceImpl extends BaseDaoServiceImpl implements UserManagerRelationService {

 

	private static final Log log = LogFactory.getLog(UserManagerRelationServiceImpl.class);



		   
		@Override
		public Long insert(UserManagerRelation userManagerRelation)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + userManagerRelation);

		if (userManagerRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		userManagerRelation.setCreateAt(currentTimeMillis);
		userManagerRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(userManagerRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + userManagerRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<UserManagerRelation> insertList(List<UserManagerRelation> userManagerRelationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (userManagerRelationList == null ? "null" : userManagerRelationList.size()));
      
		List<UserManagerRelation> resultList = null;

		if (CollectionUtils.isEmpty(userManagerRelationList)) {
			return new ArrayList<UserManagerRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserManagerRelation userManagerRelation : userManagerRelationList) {
			userManagerRelation.setCreateAt(currentTimeMillis);
			userManagerRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<UserManagerRelation>) dao.batchSave(userManagerRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + userManagerRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(UserManagerRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(UserManagerRelation userManagerRelation)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (userManagerRelation == null ? "null" : userManagerRelation.getId()));

		boolean result = false;

		if (userManagerRelation == null) {
			return true;
		}

		userManagerRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(userManagerRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + userManagerRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + userManagerRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<UserManagerRelation> userManagerRelationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (userManagerRelationList == null ? "null" : userManagerRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(userManagerRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserManagerRelation userManagerRelation : userManagerRelationList) {
			userManagerRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(userManagerRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + userManagerRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + userManagerRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public UserManagerRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		UserManagerRelation userManagerRelation = null;

		if (id == null) {
			return userManagerRelation;
		}

		try {
			userManagerRelation = (UserManagerRelation) dao.get(UserManagerRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return userManagerRelation;		
		}	
		  
    	   
		@Override
		public List<UserManagerRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<UserManagerRelation> userManagerRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<UserManagerRelation>();
		}

		try {
			userManagerRelation = (List<UserManagerRelation>) dao.getList(UserManagerRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (userManagerRelation == null ? "null" : userManagerRelation.size()));
    
		return userManagerRelation;	
		}	
		  
    	
		
	
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getUserManagerRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getUserManagerRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countUserManagerRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getUserManagerRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getUserManagerRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

