package com.ptteng.rent.user.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.rent.user.model.UserFollowRelation;
import com.ptteng.rent.user.service.UserFollowRelationService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class UserFollowRelationServiceImpl extends BaseDaoServiceImpl implements UserFollowRelationService {


    private static final Log log = LogFactory.getLog(UserFollowRelationServiceImpl.class);


    @Override
    public Long insert(UserFollowRelation userFollowRelation) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + userFollowRelation);

        if (userFollowRelation == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        userFollowRelation.setCreateAt(currentTimeMillis);
        userFollowRelation.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(userFollowRelation);
        } catch (DaoException e) {
            log.error(" insert wrong : " + userFollowRelation);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<UserFollowRelation> insertList(List<UserFollowRelation> userFollowRelationList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (userFollowRelationList == null ? "null" : userFollowRelationList.size()));

        List<UserFollowRelation> resultList = null;

        if (CollectionUtils.isEmpty(userFollowRelationList)) {
            return new ArrayList<UserFollowRelation>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (UserFollowRelation userFollowRelation : userFollowRelationList) {
            userFollowRelation.setCreateAt(currentTimeMillis);
            userFollowRelation.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<UserFollowRelation>) dao.batchSave(userFollowRelationList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + userFollowRelationList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(UserFollowRelation.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(UserFollowRelation userFollowRelation) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (userFollowRelation == null ? "null" : userFollowRelation.getId()));

        boolean result = false;

        if (userFollowRelation == null) {
            return true;
        }

        userFollowRelation.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(userFollowRelation);
        } catch (DaoException e) {
            log.error(" update wrong : " + userFollowRelation);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + userFollowRelation);
        }
        return result;
    }


    @Override
    public boolean updateList(List<UserFollowRelation> userFollowRelationList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (userFollowRelationList == null ? "null" : userFollowRelationList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(userFollowRelationList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (UserFollowRelation userFollowRelation : userFollowRelationList) {
            userFollowRelation.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(userFollowRelationList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + userFollowRelationList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + userFollowRelationList.size());

        return result;
    }


    @Override
    public UserFollowRelation getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        UserFollowRelation userFollowRelation = null;

        if (id == null) {
            return userFollowRelation;
        }

        try {
            userFollowRelation = (UserFollowRelation) dao.get(UserFollowRelation.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return userFollowRelation;
    }


    @Override
    public List<UserFollowRelation> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<UserFollowRelation> userFollowRelation = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<UserFollowRelation>();
        }

        try {
            userFollowRelation = (List<UserFollowRelation>) dao.getList(UserFollowRelation.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (userFollowRelation == null ? "null" : userFollowRelation.size()));

        return userFollowRelation;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getUserFollowRelationIdsByLesseeId(Long lesseeId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by lesseeId,start,limit  : " + lesseeId + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserFollowRelationIdsByLesseeId", new Object[]{lesseeId}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by lesseeId,start,limit)  : " + lesseeId + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getUserFollowRelationIdByLessorIdAndLesseeId(Long lessorId, Long lesseeId) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get id by lessorId,lesseeId  : " + lessorId + " , " + lesseeId);
        }
        Long id = null;

        // TODO 参数检查!

        try {


            id = (Long) dao.getMapping("getUserFollowRelationIdByLessorIdAndLesseeId", new Object[]{lessorId, lesseeId});
        } catch (DaoException e) {
            log.error(" get id wrong by lessorId,lesseeId  : " + lessorId + " , " + lesseeId);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getUserFollowRelationIdsByLessorId(Long lessorId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by lessorId,start,limit  : " + lessorId + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserFollowRelationIdsByLessorId", new Object[]{lessorId}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by lessorId,start,limit)  : " + lessorId + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countUserFollowRelationIdsByLesseeId(Long lesseeId) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by lesseeId  : " + lesseeId);
        }
        Integer count = null;


        try {

            count = dao.count("getUserFollowRelationIdsByLesseeId", new Object[]{lesseeId});


        } catch (DaoException e) {
            log.error(" count ids  wrong by lesseeId)  : " + lesseeId);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countUserFollowRelationIdsByLessorId(Long lessorId) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by lessorId  : " + lessorId);
        }
        Integer count = null;


        try {

            count = dao.count("getUserFollowRelationIdsByLessorId", new Object[]{lessorId});


        } catch (DaoException e) {
            log.error(" count ids  wrong by lessorId)  : " + lessorId);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    @Override
    public List<Long> getUserFollowRelationIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserFollowRelationIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countUserFollowRelationIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getUserFollowRelationIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getUserFollowRelationIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

