package com.ptteng.rent.user.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.rent.user.model.UserCommentRelation;
import com.ptteng.rent.user.service.UserCommentRelationService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class UserCommentRelationServiceImpl extends BaseDaoServiceImpl implements UserCommentRelationService {

 

	private static final Log log = LogFactory.getLog(UserCommentRelationServiceImpl.class);



		   
		@Override
		public Long insert(UserCommentRelation userCommentRelation)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + userCommentRelation);

		if (userCommentRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		userCommentRelation.setCreateAt(currentTimeMillis);
		userCommentRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(userCommentRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + userCommentRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<UserCommentRelation> insertList(List<UserCommentRelation> userCommentRelationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (userCommentRelationList == null ? "null" : userCommentRelationList.size()));
      
		List<UserCommentRelation> resultList = null;

		if (CollectionUtils.isEmpty(userCommentRelationList)) {
			return new ArrayList<UserCommentRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserCommentRelation userCommentRelation : userCommentRelationList) {
			userCommentRelation.setCreateAt(currentTimeMillis);
			userCommentRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<UserCommentRelation>) dao.batchSave(userCommentRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + userCommentRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(UserCommentRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(UserCommentRelation userCommentRelation)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (userCommentRelation == null ? "null" : userCommentRelation.getId()));

		boolean result = false;

		if (userCommentRelation == null) {
			return true;
		}

		userCommentRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(userCommentRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + userCommentRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + userCommentRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<UserCommentRelation> userCommentRelationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (userCommentRelationList == null ? "null" : userCommentRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(userCommentRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserCommentRelation userCommentRelation : userCommentRelationList) {
			userCommentRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(userCommentRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + userCommentRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + userCommentRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public UserCommentRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		UserCommentRelation userCommentRelation = null;

		if (id == null) {
			return userCommentRelation;
		}

		try {
			userCommentRelation = (UserCommentRelation) dao.get(UserCommentRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return userCommentRelation;		
		}	
		  
    	   
		@Override
		public List<UserCommentRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<UserCommentRelation> userCommentRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<UserCommentRelation>();
		}

		try {
			userCommentRelation = (List<UserCommentRelation>) dao.getList(UserCommentRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (userCommentRelation == null ? "null" : userCommentRelation.size()));
    
		return userCommentRelation;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUserCommentRelationIdsByLesseeId(Long lesseeId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by lesseeId,start,limit  : " + lesseeId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getUserCommentRelationIdsByLesseeId", new Object[] { lesseeId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by lesseeId,start,limit)  : " + lesseeId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUserCommentRelationIdsByLesseeIdAndLessorId(Long lesseeId,Long lessorId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by lesseeId,lessorId,start,limit  : " + lesseeId+" , "+lessorId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getUserCommentRelationIdsByLesseeIdAndLessorId", new Object[] { lesseeId,lessorId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by lesseeId,lessorId,start,limit)  : " + lesseeId+" , "+lessorId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUserCommentRelationIdsByLessorId(Long lessorId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by lessorId,start,limit  : " + lessorId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getUserCommentRelationIdsByLessorId", new Object[] { lessorId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by lessorId,start,limit)  : " + lessorId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUserCommentRelationIdsByLesseeId(Long lesseeId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by lesseeId  : " + lesseeId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUserCommentRelationIdsByLesseeId", new Object[] { lesseeId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by lesseeId)  : " + lesseeId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUserCommentRelationIdsByLesseeIdAndLessorId(Long lesseeId,Long lessorId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by lesseeId,lessorId  : " + lesseeId+" , "+lessorId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUserCommentRelationIdsByLesseeIdAndLessorId", new Object[] { lesseeId,lessorId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by lesseeId,lessorId)  : " + lesseeId+" , "+lessorId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUserCommentRelationIdsByLessorId(Long lessorId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by lessorId  : " + lessorId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUserCommentRelationIdsByLessorId", new Object[] { lessorId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by lessorId)  : " + lessorId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getUserCommentRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getUserCommentRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countUserCommentRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getUserCommentRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getUserCommentRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

