package com.ptteng.rent.user.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.rent.user.model.UserCommentCount;
import com.ptteng.rent.user.service.UserCommentCountService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class UserCommentCountServiceImpl extends BaseDaoServiceImpl implements UserCommentCountService {

 

	private static final Log log = LogFactory.getLog(UserCommentCountServiceImpl.class);



		   
		@Override
		public Long insert(UserCommentCount userCommentCount)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + userCommentCount);

		if (userCommentCount == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		userCommentCount.setCreateAt(currentTimeMillis);
		userCommentCount.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(userCommentCount);
		} catch (DaoException e) {
			log.error(" insert wrong : " + userCommentCount);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<UserCommentCount> insertList(List<UserCommentCount> userCommentCountList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (userCommentCountList == null ? "null" : userCommentCountList.size()));
      
		List<UserCommentCount> resultList = null;

		if (CollectionUtils.isEmpty(userCommentCountList)) {
			return new ArrayList<UserCommentCount>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserCommentCount userCommentCount : userCommentCountList) {
			userCommentCount.setCreateAt(currentTimeMillis);
			userCommentCount.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<UserCommentCount>) dao.batchSave(userCommentCountList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + userCommentCountList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(UserCommentCount.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(UserCommentCount userCommentCount)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (userCommentCount == null ? "null" : userCommentCount.getId()));

		boolean result = false;

		if (userCommentCount == null) {
			return true;
		}

		userCommentCount.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(userCommentCount);
		} catch (DaoException e) {
			log.error(" update wrong : " + userCommentCount);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + userCommentCount);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<UserCommentCount> userCommentCountList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (userCommentCountList == null ? "null" : userCommentCountList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(userCommentCountList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserCommentCount userCommentCount : userCommentCountList) {
			userCommentCount.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(userCommentCountList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + userCommentCountList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + userCommentCountList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public UserCommentCount getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		UserCommentCount userCommentCount = null;

		if (id == null) {
			return userCommentCount;
		}

		try {
			userCommentCount = (UserCommentCount) dao.get(UserCommentCount.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return userCommentCount;		
		}	
		  
    	   
		@Override
		public List<UserCommentCount> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<UserCommentCount> userCommentCount = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<UserCommentCount>();
		}

		try {
			userCommentCount = (List<UserCommentCount>) dao.getList(UserCommentCount.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (userCommentCount == null ? "null" : userCommentCount.size()));
    
		return userCommentCount;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUserCommentCountIdsByUid(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,start,limit  : " + uid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getUserCommentCountIdsByUid", new Object[] { uid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,start,limit)  : " + uid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUserCommentCountIdsByUid(Long uid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid  : " + uid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUserCommentCountIdsByUid", new Object[] { uid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid)  : " + uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getUserCommentCountIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getUserCommentCountIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countUserCommentCountIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getUserCommentCountIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getUserCommentCountIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

