/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.rent.user.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.rent.user.model.Verified;
import com.ptteng.rent.user.service.VerifiedService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VerifiedServiceImpl
extends BaseDaoServiceImpl
implements VerifiedService {
    private static final Log log = LogFactory.getLog(VerifiedServiceImpl.class);

    public Long insert(Verified verified) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + verified));
        if (verified == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        verified.setCreateAt(Long.valueOf(currentTimeMillis));
        verified.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)verified);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + verified));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Verified> insertList(List<Verified> verifiedList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (verifiedList == null ? "null" : Integer.valueOf(verifiedList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(verifiedList)) {
            return new ArrayList<Verified>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Verified verified : verifiedList) {
            verified.setCreateAt(Long.valueOf(currentTimeMillis));
            verified.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(verifiedList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + verifiedList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Verified.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Verified verified) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (verified == null ? "null" : verified.getId())));
        boolean result = false;
        if (verified == null) {
            return true;
        }
        verified.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)verified);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + verified));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + verified));
        }
        return result;
    }

    public boolean updateList(List<Verified> verifiedList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (verifiedList == null ? "null" : Integer.valueOf(verifiedList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(verifiedList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Verified verified : verifiedList) {
            verified.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(verifiedList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + verifiedList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + verifiedList.size()));
        return result;
    }

    public Verified getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Verified verified = null;
        if (id == null) {
            return verified;
        }
        try {
            verified = (Verified)this.dao.get(Verified.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return verified;
    }

    public List<Verified> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List verified = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Verified>();
        }
        try {
            verified = this.dao.getList(Verified.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (verified == null ? "null" : Integer.valueOf(verified.size()))));
        return verified;
    }

    public Long getVerifiedIdByUid(Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by uid  : " + uid));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getVerifiedIdByUid", new Object[]{uid});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by uid  : " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getVerifiedIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getVerifiedIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countVerifiedIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getVerifiedIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getVerifiedIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

