/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.rent.user.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.rent.user.model.UserFollowRelation;
import com.ptteng.rent.user.service.UserFollowRelationService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserFollowRelationServiceImpl
extends BaseDaoServiceImpl
implements UserFollowRelationService {
    private static final Log log = LogFactory.getLog(UserFollowRelationServiceImpl.class);

    public Long insert(UserFollowRelation userFollowRelation) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + userFollowRelation));
        if (userFollowRelation == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        userFollowRelation.setCreateAt(Long.valueOf(currentTimeMillis));
        userFollowRelation.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)userFollowRelation);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + userFollowRelation));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<UserFollowRelation> insertList(List<UserFollowRelation> userFollowRelationList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (userFollowRelationList == null ? "null" : Integer.valueOf(userFollowRelationList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(userFollowRelationList)) {
            return new ArrayList<UserFollowRelation>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (UserFollowRelation userFollowRelation : userFollowRelationList) {
            userFollowRelation.setCreateAt(Long.valueOf(currentTimeMillis));
            userFollowRelation.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(userFollowRelationList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + userFollowRelationList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(UserFollowRelation.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(UserFollowRelation userFollowRelation) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (userFollowRelation == null ? "null" : userFollowRelation.getId())));
        boolean result = false;
        if (userFollowRelation == null) {
            return true;
        }
        userFollowRelation.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)userFollowRelation);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + userFollowRelation));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + userFollowRelation));
        }
        return result;
    }

    public boolean updateList(List<UserFollowRelation> userFollowRelationList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (userFollowRelationList == null ? "null" : Integer.valueOf(userFollowRelationList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(userFollowRelationList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (UserFollowRelation userFollowRelation : userFollowRelationList) {
            userFollowRelation.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(userFollowRelationList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + userFollowRelationList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + userFollowRelationList.size()));
        return result;
    }

    public UserFollowRelation getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        UserFollowRelation userFollowRelation = null;
        if (id == null) {
            return userFollowRelation;
        }
        try {
            userFollowRelation = (UserFollowRelation)this.dao.get(UserFollowRelation.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return userFollowRelation;
    }

    public List<UserFollowRelation> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List userFollowRelation = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<UserFollowRelation>();
        }
        try {
            userFollowRelation = this.dao.getList(UserFollowRelation.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (userFollowRelation == null ? "null" : Integer.valueOf(userFollowRelation.size()))));
        return userFollowRelation;
    }

    public List<Long> getUserFollowRelationIdsByLesseeId(Long lesseeId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by lesseeId,start,limit  : " + lesseeId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserFollowRelationIdsByLesseeId", new Object[]{lesseeId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by lesseeId,start,limit)  : " + lesseeId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Long getUserFollowRelationIdByLessorIdAndLesseeId(Long lessorId, Long lesseeId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by lessorId,lesseeId  : " + lessorId + " , " + lesseeId));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getUserFollowRelationIdByLessorIdAndLesseeId", new Object[]{lessorId, lesseeId});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by lessorId,lesseeId  : " + lessorId + " , " + lesseeId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getUserFollowRelationIdsByLessorId(Long lessorId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by lessorId,start,limit  : " + lessorId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserFollowRelationIdsByLessorId", new Object[]{lessorId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by lessorId,start,limit)  : " + lessorId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countUserFollowRelationIdsByLesseeId(Long lesseeId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by lesseeId  : " + lesseeId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getUserFollowRelationIdsByLesseeId", new Object[]{lesseeId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by lesseeId)  : " + lesseeId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countUserFollowRelationIdsByLessorId(Long lessorId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by lessorId  : " + lessorId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getUserFollowRelationIdsByLessorId", new Object[]{lessorId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by lessorId)  : " + lessorId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getUserFollowRelationIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserFollowRelationIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countUserFollowRelationIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getUserFollowRelationIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getUserFollowRelationIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

