/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.rent.user.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.google.common.base.Splitter;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.rent.user.model.Orders;
import com.ptteng.rent.user.model.UserCommentCount;
import com.ptteng.rent.user.model.UserCommentRelation;
import com.ptteng.rent.user.service.OrdersService;
import com.ptteng.rent.user.service.UserCommentCountService;
import com.ptteng.rent.user.service.UserCommentRelationService;
import com.ptteng.rent.user.utils.CommentCountUtils;
import com.ptteng.rent.user.utils.RandomCommentUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class OrdersServiceImpl
extends BaseDaoServiceImpl
implements OrdersService {
    private static final Log log = LogFactory.getLog(OrdersServiceImpl.class);
    @Autowired
    private UserCommentRelationService userCommentRelationService;
    @Autowired
    private UserCommentCountService userCommentCountService;

    public Long insert(Orders orders) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + orders));
        if (orders == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        orders.setCreateAt(Long.valueOf(currentTimeMillis));
        orders.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)orders);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + orders));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Orders> insertList(List<Orders> ordersList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (ordersList == null ? "null" : Integer.valueOf(ordersList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(ordersList)) {
            return new ArrayList<Orders>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Orders orders : ordersList) {
            orders.setCreateAt(Long.valueOf(currentTimeMillis));
            orders.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(ordersList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + ordersList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Orders.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Orders orders) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (orders == null ? "null" : orders.getId())));
        boolean result = false;
        if (orders == null) {
            return true;
        }
        orders.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)orders);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + orders));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + orders));
        }
        return result;
    }

    public boolean updateList(List<Orders> ordersList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (ordersList == null ? "null" : Integer.valueOf(ordersList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(ordersList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Orders orders : ordersList) {
            orders.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(ordersList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + ordersList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + ordersList.size()));
        return result;
    }

    public Orders getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Orders orders = null;
        if (id == null) {
            return orders;
        }
        try {
            orders = (Orders)this.dao.get(Orders.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return orders;
    }

    public List<Orders> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List orders = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Orders>();
        }
        try {
            orders = this.dao.getList(Orders.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (orders == null ? "null" : Integer.valueOf(orders.size()))));
        return orders;
    }

    public Long getOrdersIdByOrderNo(String orderNo) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by orderNo  : " + orderNo));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getOrdersIdByOrderNo", new Object[]{orderNo});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by orderNo  : " + orderNo));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getOrdersIdsByStatus(Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by status,start,limit  : " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getOrdersIdsByStatus", new Object[]{status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by status,start,limit)  : " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getOrdersIdsByLesseeId(Long lesseeId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by lesseeId,start,limit  : " + lesseeId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getOrdersIdsByLesseeId", new Object[]{lesseeId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by lesseeId,start,limit)  : " + lesseeId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getOrdersIdsByLessorId(Long lessorId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by lessorId,start,limit  : " + lessorId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getOrdersIdsByLessorId", new Object[]{lessorId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by lessorId,start,limit)  : " + lessorId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Long getOrdersIdByLesseeIdAndLessorIdAndStatus(Long lesseeId, Long lessorId, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by lesseeId,lessorId,status  : " + lesseeId + " , " + lessorId + " , " + status));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getOrdersIdByLesseeIdAndLessorIdAndStatus", new Object[]{lesseeId, lessorId, status});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by lesseeId,lessorId,status  : " + lesseeId + " , " + lessorId + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public Integer countOrdersIdsByStatus(Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by status  : " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getOrdersIdsByStatus", new Object[]{status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by status)  : " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countOrdersIdsByLesseeId(Long lesseeId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by lesseeId  : " + lesseeId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getOrdersIdsByLesseeId", new Object[]{lesseeId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by lesseeId)  : " + lesseeId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countOrdersIdsByLessorId(Long lessorId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by lessorId  : " + lessorId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getOrdersIdsByLessorId", new Object[]{lessorId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by lessorId)  : " + lessorId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getOrdersIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getOrdersIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countOrdersIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getOrdersIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getOrdersIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public boolean randomSetUserCommentCount(List<Orders> notEvaluationNormalEndOrderList) throws Exception {
        if (CollectionUtils.isNotEmpty(notEvaluationNormalEndOrderList)) {
            ArrayList<UserCommentRelation> userCommentRelationList = new ArrayList<UserCommentRelation>();
            for (Orders orders : notEvaluationNormalEndOrderList) {
                List commentToList;
                UserCommentRelation userCommentRelation;
                String randomComment = RandomCommentUtil.getRandomComment();
                log.info((Object)("random comment is :" + randomComment));
                if (Orders.NOT_EVALUATION.equals(orders.getLesseeEvaluationStatus())) {
                    userCommentRelation = new UserCommentRelation();
                    userCommentRelation.setComment(randomComment);
                    userCommentRelation.setOid(orders.getId());
                    userCommentRelation.setLesseeId(orders.getLesseeId());
                    userCommentRelation.setLessorId(orders.getLessorId());
                    userCommentRelation.setType(UserCommentRelation.LESSOR_TO_LESSEE);
                    userCommentRelationList.add(userCommentRelation);
                    log.info((Object)"------------------------------------------");
                    commentToList = Splitter.on((String)",").trimResults().splitToList((CharSequence)randomComment);
                    log.info((Object)("common to list size is :" + commentToList.size()));
                    this.getCommentCount(commentToList, orders.getLesseeId());
                    orders.setLesseeEvaluationStatus(Orders.IS_EVALUATION);
                    continue;
                }
                if (Orders.NOT_EVALUATION.equals(orders.getLessorEvaluationStatus())) {
                    userCommentRelation = new UserCommentRelation();
                    userCommentRelation.setOid(orders.getId());
                    userCommentRelation.setComment(randomComment);
                    userCommentRelation.setLesseeId(orders.getLesseeId());
                    userCommentRelation.setLessorId(orders.getLessorId());
                    userCommentRelation.setType(UserCommentRelation.LESSEE_TO_LESSOR);
                    userCommentRelationList.add(userCommentRelation);
                    log.info((Object)"------------------------------------------");
                    commentToList = Splitter.on((String)",").trimResults().splitToList((CharSequence)randomComment);
                    log.info((Object)("common to list size is :" + commentToList.size()));
                    this.getCommentCount(commentToList, orders.getLessorId());
                    orders.setLessorEvaluationStatus(Orders.IS_EVALUATION);
                    continue;
                }
                log.info((Object)"**********************");
                log.info((Object)"-------- :p -----------");
            }
            this.updateList(notEvaluationNormalEndOrderList);
            List userCommentRelations = this.userCommentRelationService.insertList(userCommentRelationList);
            if (CollectionUtils.isEmpty((Collection)userCommentRelations)) {
                log.info((Object)"not comment normal order insert comment error");
            }
        }
        return false;
    }

    private void getCommentCount(List<String> commentList, Long uid) throws Exception {
        List userCommentCountIds = this.userCommentCountService.getUserCommentCountIdsByUid(uid, Integer.valueOf(0), Integer.valueOf(10));
        if (CollectionUtils.isEmpty((Collection)userCommentCountIds)) {
            UserCommentCount userCount = new UserCommentCount();
            log.info((Object)("-------------------" + userCount));
            CommentCountUtils.countComment(commentList, userCount);
            userCount.setUid(uid);
            Long userCommentCountId = this.userCommentCountService.insert(userCount);
            log.info((Object)("user comment count id is :" + userCommentCountId));
        } else {
            Long userCommentCountId = (Long)userCommentCountIds.get(0);
            UserCommentCount userCommentCount = this.userCommentCountService.getObjectById(userCommentCountId);
            CommentCountUtils.countComment(commentList, userCommentCount);
            boolean b = this.userCommentCountService.update(userCommentCount);
            if (b) {
                log.info((Object)"userCommentCount update success");
            } else {
                log.info((Object)"userCommentCount update fail");
                throw new Exception("update UserCommentCount Exception");
            }
        }
    }
}

