package com.ptteng.rent.user.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.rent.user.model.UserCommentRelation;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface UserCommentRelationService extends BaseDaoService {

	



   		   
		
		public Long insert(UserCommentRelation userCommentRelation)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<UserCommentRelation> insertList(List<UserCommentRelation> userCommentRelationList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(UserCommentRelation userCommentRelation)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<UserCommentRelation> userCommentRelationList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public UserCommentRelation getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<UserCommentRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countUserCommentRelationIdsByLesseeId(Long lesseeId)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countUserCommentRelationIdsByLesseeIdAndLessorId(Long lesseeId, Long lessorId)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countUserCommentRelationIdsByLessorId(Long lessorId)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getUserCommentRelationIdsByLesseeId(Long lesseeId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getUserCommentRelationIdsByLesseeIdAndLessorId(Long lesseeId, Long lessorId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getUserCommentRelationIdsByLessorId(Long lessorId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getUserCommentRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countUserCommentRelationIds() throws ServiceException, ServiceDaoException;
	

}

