package com.ptteng.rent.user.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "user")
public class User implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 3835508232698703872L;

    /**
     * 用户状态：解冻
     */
    public static final Integer STATUS_OFF = 1;

    /**
     * 用户状态：冻结
     */
    public static final Integer STATUS_ON = 0;

    /**
     * 用户身份：未知
     */
    public static final Integer UNKNOWN = 0;

    /**
     * 用户身份：承租人
     */
    public static final Integer LESSEE = 1;

    /**
     * 用户身份：出租人
     */
    public static final Integer LESSOR = 2;

    /**
     * 用户状态：未知
     */
    public static final Integer USER_STATUS_UNKNOWN = 0;

    /**
     * 用户状态：授权
     */
    public static final Integer USER_STATUS_AUTHORIZED = 1;

    /**
     * 用户状态：注册
     */
    public static final Integer USER_STATUS_REGISTERED = 2;

    /**
     * 用户状态：实名认证
     */
    public static final Integer USER_STATUS_VERIFIED = 3;

    /**
     * 登录状态：未登录
     */
    public static final Integer NOT_LOGIN = 1;

    /**
     * 登录状态：登录
     */
    public static final Integer LOGIN = 2;

    /**
     * 用户标签：同城
     */
    public static final String CITY = "同城";

    /**
     * 用户标签：最热
     */
    public static final String HOT = "最热";

    /**
     * 关注数增加1
     */
    public static final Integer PLUS_ONE = 1;

    /**
     * 成年
     */
    public static final Integer ADULT = 18;

    /**
     * 已关注
     */
    public static final Integer IS_FOLLOW = 1;

    /**
     * 未关注
     */
    public static final Integer IS_NOT_FOLLOW = 2;

    /**
     * 出租用户最少收费（元）
     */
    public static final Integer MIN_CHARGE = 1;

    /**
     * 用户须知是否弹窗：默认=0弹窗（24小时弹一次窗）
     */
    public static final Integer BULLET = 0;

    /**
     * 用户须知是否弹窗：1=永久不弹窗
     */
    public static final Integer NOT_BULLET = 1;

    /**
     * 24小时时间戳
     */
    public static final Long ONE_DAY_MILL = 86400000L;

    /**
     * 新订单数量，订单状态变更红点默认值
     */
    public static final Integer NEW_ORDER_AND_STATUS = 0;

    /**
     * 新订单
     */
    public static final Integer NEW_ORDER = 1;


    private Long id;

    /**
     * 昵称
     */
    private String nick;

    /**
     * 性别
     */
    private Integer sex;

    /**
     * 头像
     */
    private String avatar;

    /**
     * 常住地
     */
    private String permanentAddress;

    /**
     * 承租人下单数量（正常结束订单数量）
     */
    private Integer lesseeOrders = 0;


    /**
     * 出租人接单数量（正常结束订单数量）
     */
    private Integer lessorOrders = 0;

    /**
     * 手机号
     */
    private String mobile;


    private String openID;

    /**
     * 用户身份：0=未知，1=承租人，2=出租人
     */
    private Integer userType;

    /**
     * 推荐人ID(经纪人ID)
     */
    private Long recommenderId;

    /**
     * 年龄
     */
    private Long age;

    /**
     * 身高
     */
    private Integer height;

    /**
     * 体重
     */
    private Integer weight;

    /**
     * 兴趣爱好
     */
    private String hobby;

    /**
     * 档期
     */
    private String schedule;

    /**
     * 微信号
     */
    private String WeChat;

    /**
     * 出租人收费
     */
    private String toll;


    private String videoUrl;


    private String imgUrl;
    /**
     * 视频封面
     */
    private String coverUrl;


    private String positioning;


    private String tag;


    /**
     * 收费上限
     */
    private String feeCap = "0";


    private String name;


    private String IDNumber;


    /**
     * 用户状态：0=未知，1=注册，2.授权，3=实名
     */
    private Integer userStatus;


    /**
     * 登录状态：0=未知，1=未登录，2=登录
     */
    private Integer loginStatus;


    /**
     * 用户账号状态：0=冻结，1=解冻
     */
    private Integer status;

    /**
     * 订单状态变更红点
     */
    private Integer ordersStatus;

    /**
     * 新订单数量
     */
    private Integer newOrders;

    /**
     * 出租人技能
     */
    private String skill;

    /**
     * 用户手动选择定位
     */
    private String manuallySelectPositioning;

    /**
     * 关注人数
     */
    private Integer follow;

    /**
     * 区
     */
    private String area;

    /**
     * 上一次弹窗时间
     */
    private Long userNoticeAt;

    /**
     * 用户选择是否弹窗
     */
    private Integer isBullet;

    private Long createBy;


    private Long updateBy;


    private Long updateAt;


    private Long createAt;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "nick")
    public String getNick() {
        return nick;
    }


    public void setNick(String nick) {
        this.nick = nick;
    }

    @Column(name = "sex")
    public Integer getSex() {
        return sex;
    }


    public void setSex(Integer sex) {
        this.sex = sex;
    }

    @Column(name = "avatar")
    public String getAvatar() {
        return avatar;
    }


    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    @Column(name = "permanent_address")
    public String getPermanentAddress() {
        return permanentAddress;
    }


    public void setPermanentAddress(String permanentAddress) {
        this.permanentAddress = permanentAddress;
    }

    @Column(name = "lessee_orders")
    public Integer getLesseeOrders() {
        return lesseeOrders;
    }


    public void setLesseeOrders(Integer lesseeOrders) {
        this.lesseeOrders = lesseeOrders;
    }

    @Column(name = "lessor_orders")
    public Integer getLessorOrders() {
        return lessorOrders;
    }


    public void setLessorOrders(Integer lessorOrders) {
        this.lessorOrders = lessorOrders;
    }

    @Column(name = "mobile")
    public String getMobile() {
        return mobile;
    }


    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    @Column(name = "open_id")
    public String getOpenID() {
        return openID;
    }


    public void setOpenID(String openID) {
        this.openID = openID;
    }

    @Column(name = "user_type")
    public Integer getUserType() {
        return userType;
    }


    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    @Column(name = "recommender_id")
    public Long getRecommenderId() {
        return recommenderId;
    }


    public void setRecommenderId(Long recommenderId) {
        this.recommenderId = recommenderId;
    }

    @Column(name = "age")
    public Long getAge() {
        return age;
    }


    public void setAge(Long age) {
        this.age = age;
    }

    @Column(name = "height")
    public Integer getHeight() {
        return height;
    }


    public void setHeight(Integer height) {
        this.height = height;
    }

    @Column(name = "hobby")
    public String getHobby() {
        return hobby;
    }


    public void setHobby(String hobby) {
        this.hobby = hobby;
    }

    @Column(name = "schedule")
    public String getSchedule() {
        return schedule;
    }


    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    @Column(name = "we_chat")
    public String getWeChat() {
        return WeChat;
    }


    public void setWeChat(String WeChat) {
        this.WeChat = WeChat;
    }

    @Column(name = "toll")
    public String getToll() {
        return toll;
    }


    public void setToll(String toll) {
        this.toll = toll;
    }

    @Column(name = "video_url")
    public String getVideoUrl() {
        return videoUrl;
    }


    public void setVideoUrl(String videoUrl) {
        this.videoUrl = videoUrl;
    }

    @Column(name = "img_url")
    public String getImgUrl() {
        return imgUrl;
    }


    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    @Column(name = "positioning")
    public String getPositioning() {
        return positioning;
    }


    public void setPositioning(String positioning) {
        this.positioning = positioning;
    }

    @Column(name = "tag")
    public String getTag() {
        return tag;
    }


    public void setTag(String tag) {
        this.tag = tag;
    }

    @Column(name = "fee_cap")
    public String getFeeCap() {
        return feeCap;
    }


    public void setFeeCap(String feeCap) {
        this.feeCap = feeCap;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "id_number")
    public String getIDNumber() {
        return IDNumber;
    }


    public void setIDNumber(String IDNumber) {
        this.IDNumber = IDNumber;
    }

    @Column(name = "user_status")
    public Integer getUserStatus() {
        return userStatus;
    }


    public void setUserStatus(Integer userStatus) {
        this.userStatus = userStatus;
    }

    @Column(name = "login_status")
    public Integer getLoginStatus() {
        return loginStatus;
    }


    public void setLoginStatus(Integer loginStatus) {
        this.loginStatus = loginStatus;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "orders_status")
    public Integer getOrdersStatus() {
        return ordersStatus;
    }


    public void setOrdersStatus(Integer ordersStatus) {
        this.ordersStatus = ordersStatus;
    }

    @Column(name = "new_orders")
    public Integer getNewOrders() {
        return newOrders;
    }


    public void setNewOrders(Integer newOrders) {
        this.newOrders = newOrders;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "skill")
    public String getSkill() {
        return skill;
    }

    public void setSkill(String skill) {
        this.skill = skill;
    }

    @Column(name = "weight")
    public Integer getWeight() {
        return weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    @Column(name = "manually_select_positioning")
    public String getManuallySelectPositioning() {
        return manuallySelectPositioning;
    }

    public void setManuallySelectPositioning(String manuallySelectPositioning) {
        this.manuallySelectPositioning = manuallySelectPositioning;
    }

    @Column(name = "follow")
    public Integer getFollow() {
        return follow;
    }

    public void setFollow(Integer follow) {
        this.follow = follow;
    }

    @Column(name = "area")
    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    @Column(name = "user_notice_at")
    public Long getUserNoticeAt() {
        return userNoticeAt;
    }

    @Column(name = "is_bullet")
    public Integer getIsBullet() {
        return isBullet;
    }

    public void setUserNoticeAt(Long userNoticeAt) {
        this.userNoticeAt = userNoticeAt;
    }

    public void setIsBullet(Integer isBullet) {
        this.isBullet = isBullet;
    }

    @Column(name = "cover_url")
    public String getCoverUrl() {
        return coverUrl;
    }

    public void setCoverUrl(String coverUrl) {
        this.coverUrl = coverUrl;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

