package com.ptteng.rent.user.model;

import java.io.Serializable;
import java.math.BigDecimal;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "orders")
public class Orders implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 759116176973901824L;

    /**
     * 支付状态/订单状态：未支付
     */
    public static final Integer UNPAID = 0;

    /**
     * 支付状态：支付成功
     */
    public static final Integer PAY_SUCCESS = 1;

    /**
     * 支付状态：支付失败
     */
    public static final Integer PAY_FAIL = 2;

    /**
     * 承租人已支付，出租人未确认-> 待确认状态
     */
    public static final Integer LESSOR_IS_NOT_CONFIRMED = 1;

    /**
     * 承租人已支付，出租人已确定 -> 进行中
     */
    public static final Integer LESSOR_IS_CONFIRMED = 2;

    /**
     * 承租人已支付，出租人未确认，承租人退款 -> 待确认状态承租人申请退款   {退全款}
     */
    public static final Integer LESSOR_IS_CONFIRMED_LESSEE_REFUND = 3;

    /**
     * 承租人已支付，出租人已确定，进行中，承租人申请退款，出租人未确认
     */
    public static final Integer PROCESSING_LESSEE_REFUND_LESSOR_IS_NOT_CONFIRMED = 4;

    /**
     * 承租人已支付，出租人已确定，进行中，承租人申请退款，出租人已确认，退款中  {不退还服务费}
     */
    public static final Integer PROCESSING_LESSEE_REFUND_LESSOR_IS_CONFIRMED = 5;

    /**
     * 承租人已支付，出租人已确定，进行中，承租人申请退款，出租人三个小时内未确认，系统自动退款，退款中  {不退还服务费}
     */
    public static final Integer PROCESSING_LESSEE_REFUND_SYSTEM_REFUND = 6;

    /**
     * 承租人已支付，出租人已确定，进行中，出租人申请终止订单，已终止   {不退还服务费}
     */
    public static final Integer PROCESSING_LESSOR_TERMINATION_ORDER = 7;

    /**
     * 待确认订单在超出预定开始时间后未确定自动取消，已取消 {退全款}
     */
    public static final Integer ORDER_TIME_OUT_CANCEL = 8;

    /**
     * 承租人已支付，出租人已确认，计时结束，正常完成订单 -> 已结束
     */
    public static final Integer COMPLETE_THE_ORDER_NORMALLY = 9;

    /**
     * 所有异常结束订单状态 -> 已终止
     */
    public static final Integer TERMINATED = 10;

    /**
     * 订单正常结束，商户向出租人已转账
     */
    public static final Integer TRANSFERRED = 11;

    /**
     * 异常订单，商户向承租人已退款
     */
    public static final Integer REFUNDED = 12;

    /**
     * 进行中订单，承租人申请退款，出租人拒绝退款
     */
    public static final Integer LESSOR_REFUSES_REFUND = 13;

    /**
     * 待确认状态订单，出租人拒绝接单 {退全款}
     */
    public static final Integer REFUSE_TO_TAKE_ORDERS = 14;

    /**
     * 出租人是否接受订单：1：接受
     */
    public static final Integer IS_ACCEPT = 1;

    /**
     * 出租人是否接受订单：2：不接受
     */
    public static final Integer IS_NOT_ACCEPT = 2;

    /**
     * 出租人是否同意进行中订单退款：1：同意
     */
    public static final Integer AGREE = 1;

    /**
     * 出租人是否同意进行中订单退款：2：不同意
     */
    public static final Integer DISAGREE = 2;


    /**
     * 最少租赁时间一小时
     */
    public static final Long AT_LEAST = 3600000L;

    /**
     * 进行中订单，出租人拒绝，承租人能否进行下一次退款申请时间，十分钟
     */
    public static final Long TEN_MINUTES_MILL = 600000L;

    /**
     * 正常结束订单24小时内是否评价，超过24小时系统自动评价
     */
    public static final Long ONE_DAY = 86400000L;

    /**
     * 进行中订单，承租人申请终止订单，出租人在3小时内未做出回应，自动同意   三小时
     */
    public static final Long THREE_HOURS = 10800000L;

    /**
     * 最少输入10个字
     */
    public static final Integer MINIMUM_INPUT = 10;

    /**
     * 承租人最多非结束状态订单5个；
     */
    public static final Integer LESSEE_MAX_ORDERS = 5;

    /**
     * 订单是否评价：1=未评价
     */
    public static final Integer NOT_EVALUATION = 1;

    /**
     * 订单是否评价：2=已评价
     */
    public static final Integer IS_EVALUATION = 2;

    /**
     * 进行中订单，出租人拒绝承租人退款，承租人能否进行下一次退款申请   可以进行
     */
    public static final Integer IS_NEXT_REFUND = 1;

    /**
     * 进行中订单，出租人拒绝承租人退款，承租人能否进行下一次退款申请   不可以进行
     */
    public static final Integer IS_NOT_NEXT_REFUND = 2;

    /**
     * 待确认
     */
    public static final Integer TO_BE_CONFIRMED = 0;

    /**
     * 进行中
     */
    public static final Integer PROCESSING = 1;

    /**
     * 退款中
     */
    public static final Integer REFUNDING = 2;

    /**
     * 已结束
     */
    public static final Integer OVER = 3;

    /**
     * 已终止  Terminated
     */
    public static final Integer IS_TERMINATED = 4;

    /**
     * 我的订单，是否获取列表信息
     */
    public static final Integer YES = 1;

    /**
     * 该订单经纪人是否提现（1=未提现）
     */
    public static final Integer IS_NOT_WITHDRAW = 1;

    /**
     * 该订单经纪人是否提现（2=已提现）
     */
    public static final Integer IS_WITHORAW = 2;


    private Long id;

    /**
     * 承租人ID
     */
    private Long lesseeId;

    /**
     * 出租人ID
     */
    private Long lessorId;

    /**
     * 租赁开始时间
     */
    private Long leaseStartAt;

    /**
     * 租赁结束时间
     */
    private Long leaseEndAt;

    /**
     * 订单价格
     */
    private BigDecimal price;

    /**
     * 总支付金额（订单价格+服务费）
     */
    private BigDecimal totalPrice;

    /**
     * 承租人留言
     */
    private String lesseeMessage;

    /**
     * 出租人留言
     */
    private String lessorMessage;

    /**
     * 承租人支付时间
     */
    private Long payAt;

    /**
     * 支付状态：1=支付成功，2=支付失败
     */
    private Integer payStatus;

    /**
     * 支付状态
     */
    private Integer status;

    /**
     * 承租人申请退款时间
     */
    private Long refundAt;

    /**
     * 订单号
     */
    private String orderNo;

    /**
     * 订单提交城市（用户当前定位城市）
     */
    private String positioning;

    /**
     * 经纪人ID
     */
    private Long mid;

    /**
     * 承租人服务费
     */
    private BigDecimal lesseeServiceFee;

    /**
     * 出租人服务费
     */
    private BigDecimal lessorServiceFee;

    /**
     * 服务内容（出租人技能)
     */
    private String serviceContent;

    /**
     * 进行中订单状态，承租人申请退款，出租人拒绝退款时间；
     */
    private Long refuseAt;

    /**
     * 已结束订单，承租人是否评价；
     * 约定：默认=0，未评价=1，已评价=2
     */
    private Integer lesseeEvaluationStatus = 0;

    /**
     * 已结束订单，出租人是否评价；
     * 约定：默认=0，未评价=1，已评价=2
     */
    private Integer lessorEvaluationStatus = 0;

    /**
     * 经纪人是否提款
     */
    private Integer isWithdraw = 1;

    /**
     * 订单正常结束时间
     */
    private Long endOfOrderAt;

    /**
     * 退款订单号
     */
    private String refundOrderNo;

    private Long createBy;


    private Long updateBy;


    private Long updateAt;


    private Long createAt;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "lessee_id")
    public Long getLesseeId() {
        return lesseeId;
    }


    public void setLesseeId(Long lesseeId) {
        this.lesseeId = lesseeId;
    }

    @Column(name = "lessor_id")
    public Long getLessorId() {
        return lessorId;
    }


    public void setLessorId(Long lessorId) {
        this.lessorId = lessorId;
    }

    @Column(name = "lease_start_at")
    public Long getLeaseStartAt() {
        return leaseStartAt;
    }


    public void setLeaseStartAt(Long leaseStartAt) {
        this.leaseStartAt = leaseStartAt;
    }

    @Column(name = "lease_end_at")
    public Long getLeaseEndAt() {
        return leaseEndAt;
    }


    public void setLeaseEndAt(Long leaseEndAt) {
        this.leaseEndAt = leaseEndAt;
    }

    @Column(name = "price")
    public BigDecimal getPrice() {
        return price;
    }


    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    @Column(name = "total_price")
    public BigDecimal getTotalPrice() {
        return totalPrice;
    }


    public void setTotalPrice(BigDecimal totalPrice) {
        this.totalPrice = totalPrice;
    }

    @Column(name = "lessee_message")
    public String getLesseeMessage() {
        return lesseeMessage;
    }


    public void setLesseeMessage(String lesseeMessage) {
        this.lesseeMessage = lesseeMessage;
    }

    @Column(name = "lessor_message")
    public String getLessorMessage() {
        return lessorMessage;
    }


    public void setLessorMessage(String lessorMessage) {
        this.lessorMessage = lessorMessage;
    }

    @Column(name = "pay_at")
    public Long getPayAt() {
        return payAt;
    }


    public void setPayAt(Long payAt) {
        this.payAt = payAt;
    }

    @Column(name = "pay_status")
    public Integer getPayStatus() {
        return payStatus;
    }


    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "refund_at")
    public Long getRefundAt() {
        return refundAt;
    }


    public void setRefundAt(Long refundAt) {
        this.refundAt = refundAt;
    }

    @Column(name = "order_no")
    public String getOrderNo() {
        return orderNo;
    }


    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "positioning")
    public String getPositioning() {
        return positioning;
    }

    public void setPositioning(String positioning) {
        this.positioning = positioning;
    }

    @Column(name = "mid")
    public Long getMid() {
        return mid;
    }

    public void setMid(Long mid) {
        this.mid = mid;
    }

    @Column(name = "lessee_service_fee")
    public BigDecimal getLesseeServiceFee() {
        return lesseeServiceFee;
    }

    @Column(name = "lessor_service_fee")
    public BigDecimal getLessorServiceFee() {
        return lessorServiceFee;
    }

    public void setLesseeServiceFee(BigDecimal lesseeServiceFee) {
        this.lesseeServiceFee = lesseeServiceFee;
    }

    public void setLessorServiceFee(BigDecimal lessorServiceFee) {
        this.lessorServiceFee = lessorServiceFee;
    }


    @Column(name = "service_content")
    public String getServiceContent() {
        return serviceContent;
    }

    public void setServiceContent(String serviceContent) {
        this.serviceContent = serviceContent;
    }

    @Column(name = "refuse_at")
    public Long getRefuseAt() {
        return refuseAt;
    }

    public void setRefuseAt(Long refuseAt) {
        this.refuseAt = refuseAt;
    }

    @Column(name = "lessee_evaluation_status")
    public Integer getLesseeEvaluationStatus() {
        return lesseeEvaluationStatus;
    }

    @Column(name = "lessor_evaluation_status")
    public Integer getLessorEvaluationStatus() {
        return lessorEvaluationStatus;
    }

    public void setLesseeEvaluationStatus(Integer lesseeEvaluationStatus) {
        this.lesseeEvaluationStatus = lesseeEvaluationStatus;
    }

    public void setLessorEvaluationStatus(Integer lessorEvaluationStatus) {
        this.lessorEvaluationStatus = lessorEvaluationStatus;
    }

    @Column(name = "end_of_order_at")
    public Long getEndOfOrderAt() {
        return endOfOrderAt;
    }

    public void setEndOfOrderAt(Long endOfOrderAt) {
        this.endOfOrderAt = endOfOrderAt;
    }

    @Column(name = "is_withdraw")
    public Integer getIsWithdraw() {
        return isWithdraw;
    }

    public void setIsWithdraw(Integer isWithdraw) {
        this.isWithdraw = isWithdraw;
    }

    @Column(name = "refund_order_no")
    public String getRefundOrderNo() {
        return refundOrderNo;
    }

    public void setRefundOrderNo(String refundOrderNo) {
        this.refundOrderNo = refundOrderNo;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

