/**
 * 
 */
package com.ptteng.sca.rent.user.client;

import java.util.List;
import java.util.Map;

import com.ptteng.rent.user.model.Orders;
import com.ptteng.rent.user.model.UserCommentCount;
import com.ptteng.rent.user.service.OrdersService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.rent.user.service.UserCommentCountService;

public class OrdersSCAClient implements OrdersService {

    private OrdersService ordersService;

	private UserCommentCountService userCommentCountService;

	public OrdersService getOrdersService() {
		return ordersService;
	}
	
	
	public void setOrdersService(OrdersService ordersService) {
		this.ordersService =ordersService;
	}
	
	
			   
		@Override
		public Long insert(Orders orders)throws ServiceException, ServiceDaoException{
		
		return ordersService.insert(orders);
		          
		
		}	
		  
    	   
		@Override
		public List<Orders> insertList(List<Orders> ordersList)throws ServiceException, ServiceDaoException{
		
		return ordersService.insertList(ordersList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return ordersService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Orders orders)throws ServiceException, ServiceDaoException{
		
		return ordersService.update(orders);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Orders> ordersList)throws ServiceException, ServiceDaoException{
		
		return ordersService.updateList(ordersList);
		          
		
		}	
		  
    	   
		@Override
		public Orders getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return ordersService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Orders> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return ordersService.getObjectsByIds(ids);
		          
		
		}

	@Override
	public boolean randomSetUserCommentCount(List<Orders> notEvaluationNormalEndOrderList) throws ServiceException,
            ServiceDaoException {
		return updateList(notEvaluationNormalEndOrderList);
	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getOrdersIdByOrderNo(String orderNo)throws ServiceException, ServiceDaoException{
		
		return ordersService.getOrdersIdByOrderNo(orderNo);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getOrdersIdsByStatus(Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return ordersService.getOrdersIdsByStatus(status,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getOrdersIdsByLesseeId(Long lesseeId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return ordersService.getOrdersIdsByLesseeId(lesseeId,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getOrdersIdsByLessorId(Long lessorId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return ordersService.getOrdersIdsByLessorId(lessorId,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getOrdersIdByLesseeIdAndLessorIdAndStatus(Long lesseeId,Long lessorId,Integer status)throws ServiceException, ServiceDaoException{
		
		return ordersService.getOrdersIdByLesseeIdAndLessorIdAndStatus(lesseeId,lessorId,status);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countOrdersIdsByStatus(Integer status)throws ServiceException, ServiceDaoException{
		
		return ordersService.countOrdersIdsByStatus(status);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countOrdersIdsByLesseeId(Long lesseeId)throws ServiceException, ServiceDaoException{
		
		return ordersService.countOrdersIdsByLesseeId(lesseeId);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countOrdersIdsByLessorId(Long lessorId)throws ServiceException, ServiceDaoException{
		
		return ordersService.countOrdersIdsByLessorId(lessorId);
	
	
	}
	
		
	
		@Override
	public List<Long> getOrdersIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return ordersService.getOrdersIds(start, limit);
	}

	@Override
	public Integer countOrdersIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return ordersService.countOrdersIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return ordersService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return ordersService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   ordersService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.ordersService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


 
}

