package com.ptteng.rent.user.service;

import java.util.List;
import java.util.Map;

import com.ptteng.rent.user.model.UserCommentCount;
import org.osoa.sca.annotations.Remotable;

import com.ptteng.rent.user.model.Orders;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface OrdersService extends BaseDaoService {


    public Long insert(Orders orders) throws ServiceException, ServiceDaoException;


    public List<Orders> insertList(List<Orders> ordersList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(Orders orders) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<Orders> ordersList) throws ServiceException, ServiceDaoException;


    public Orders getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<Orders> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    public boolean randomSetUserCommentCount(List<Orders> notEvaluationNormalEndOrderList) throws Exception;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countOrdersIdsByStatus(Integer status) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countOrdersIdsByLesseeId(Long lesseeId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countOrdersIdsByLessorId(Long lessorId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getOrdersIdByOrderNo(String orderNo) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getOrdersIdsByStatus(Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getOrdersIdsByLesseeId(Long lesseeId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getOrdersIdsByLessorId(Long lessorId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getOrdersIdByLesseeIdAndLessorIdAndStatus(Long lesseeId, Long lessorId, Integer status) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getOrdersIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countOrdersIds() throws ServiceException, ServiceDaoException;


}

