package com.ptteng.rent.user.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "withdraw")
public class Withdraw implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 2220078793446003712L;

    /**
     * 提现状态：待处理
     */
    public static final Integer PENDING = 1;

    /**
     * 提现状态：已完成
     */
    public static final Integer COMPLETED = 2;


    private Long id;

    /**
     * 经纪人ID
     */
    private Long brokerId;

    /**
     * 银行卡号
     */
    private String bankCardNumber;

    /**
     * 提现申请状态
     */
    private Integer status;


    /**
     * 发卡银行
     */
    private String issuingBank;

    /**
     * 持卡人姓名
     */
    private String bankCardOwnerName;

    /**
     * 提现金额
     */
    private BigDecimal withdrawalAmount;


    private Long createBy;


    private Long updateBy;


    private Long updateAt;


    private Long createAt;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "bank_card_number")
    public String getBankCardNumber() {
        return bankCardNumber;
    }


    public void setBankCardNumber(String bankCardNumber) {
        this.bankCardNumber = bankCardNumber;
    }

    @Column(name = "issuing_bank")
    public String getIssuingBank() {
        return issuingBank;
    }


    public void setIssuingBank(String issuingBank) {
        this.issuingBank = issuingBank;
    }

    @Column(name = "bank_card_owner_name")
    public String getBankCardOwnerName() {
        return bankCardOwnerName;
    }


    public void setBankCardOwnerName(String bankCardOwnerName) {
        this.bankCardOwnerName = bankCardOwnerName;
    }

    @Column(name = "withdrawal_amount")
    public BigDecimal getWithdrawalAmount() {
        return withdrawalAmount;
    }


    public void setWithdrawalAmount(BigDecimal withdrawalAmount) {
        this.withdrawalAmount = withdrawalAmount;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "broker_id")
    public Long getBrokerId() {
        return brokerId;
    }

    public void setBrokerId(Long brokerId) {
        this.brokerId = brokerId;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

