package com.ptteng.rent.user.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "verified")
public class Verified implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 4251964747456491520L;

    /**
     * 每日实名认证失败机会
     */
    public static final Integer FAIL_COUNT = 3;

    /**
     * 验证次数初始化
     */
    public static final Integer INIT = 1;

    /**
     * 每次请求最少间隔30
     */
    public static final Long INTERVAL = 60000L;

    /**
     * 匹配结果成功
     */
    public static final int SUCCESS = 0;

    public static final int BUSY_CODE = 110;

    public static final int ERROR_CODE = -2;

    /**
     * 匹配
     */
    public static final String MATCH = "匹配";

    public static final Integer ARREARS = 2;


    private Long id;


    private Long uid;


    /**
     * 每天验证次数统计
     */
    private Integer count;

    /**
     * 发送时间
     */
    private Long sendAt;


    private Long createAt;


    private Long updateAt;


    private Long createBy;


    private Long updateBy;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "uid")
    public Long getUid() {
        return uid;
    }


    public void setUid(Long uid) {
        this.uid = uid;
    }

    @Column(name = "count")
    public Integer getCount() {
        return count;
    }


    public void setCount(Integer count) {
        this.count = count;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "send_at")
    public Long getSendAt() {
        return sendAt;
    }

    public void setSendAt(Long sendAt) {
        this.sendAt = sendAt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

