package com.ptteng.rent.user.utils;

/**
 * @author cjsff
 * @date 2018/6/12
 */
public enum OrdersErrorCode {

    /**承租人ID为空*/
    lesseeIdIsEmpty(-4008),

    /**出租人ID为空*/
    lessorIdIsEmpty(-4009),

    /**租赁起始时间为空*/
    leaseStartAtIsEmpty(-4010),

    /**租赁结束时间为空*/
    leaseEndAtIsEmpty(-4011),

    /**订单价格为空*/
    priceIsEmpty(-4012),

    /**总支付金额为空*/
    totalPriceIsEmpty(-4019),

    /**承租人留言为空*/
    lesseeMessageIsEmpty(-4020),

    /**订单提交城市（承租人当前定位城市）为空*/
    positioningIsEmpty(-4021),

    /**承租人服务费为空*/
    lesseeServiceFeeIsEmpty(-4022),

    /**出租人服务费为空*/
    lessorServiceFeeIsEmpty(-4023),

    /**服务内容为空*/
    serviceContentIsEmpty(-4024);



    private int value;

    OrdersErrorCode(int value) {
        this.value = value;
    }

    public int getValue(){
        return value;
    }
}
