package com.ptteng.rent.user.utils;

import com.ptteng.rent.user.model.Orders;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.impl.CriteriaImpl;

import java.math.BigDecimal;

public class OrdersCheck {

    private static final Log log = LogFactory.getLog(OrdersCheck.class);

    /**
     * 创建订单校验
     * @param lesseeId
     * @param lessorId
     * @param leaseStartAt
     * @param leaseEndAt
     * @param price
     * @param totalPrice
     * @param lesseeMessage
     * @param positioning
     * @return
     */
    public static Integer checkOrdersParams(Long lesseeId, Long lessorId, Long leaseStartAt, Long leaseEndAt,
                                            BigDecimal price, BigDecimal totalPrice, String lesseeMessage, String
                                                    positioning,BigDecimal lesseeServiceFee,BigDecimal lessorServiceFee) {

        if (DataUtils.isNullOrEmpty(lesseeId)) {

            log.info("lesseeId is :" + lesseeId);

            return OrdersErrorCode.lesseeIdIsEmpty.getValue();

        }

        if (DataUtils.isNullOrEmpty(lessorId)) {

            log.info("lessorId is :" + lessorId);

            return OrdersErrorCode.lessorIdIsEmpty.getValue();

        }

        if (DataUtils.isNullOrEmpty(leaseStartAt)) {

            log.info("leaseStartAt is :" + leaseStartAt);

            return OrdersErrorCode.leaseStartAtIsEmpty.getValue();

        }

        if (DataUtils.isNullOrEmpty(leaseEndAt)) {

            log.info("leaseEndAt is :" + leaseEndAt);

            return OrdersErrorCode.leaseEndAtIsEmpty.getValue();

        }

        if (DataUtils.isNullOrEmpty(price)) {

            log.info("price is :" + price);

            return OrdersErrorCode.priceIsEmpty.getValue();

        }

        if (DataUtils.isNullOrEmpty(totalPrice)) {

            log.info("total price is :" + totalPrice);

            return OrdersErrorCode.totalPriceIsEmpty.getValue();

        }

        if (DataUtils.isNullOrEmpty(lesseeMessage)) {

            log.info("lessee message is :" + lesseeMessage);

            return OrdersErrorCode.lesseeMessageIsEmpty.getValue();

        }

        if (lesseeMessage.length() < Orders.MINIMUM_INPUT) {

            log.info("Enter at least 10 words");

            return -3006;
        }

        if (DataUtils.isNullOrEmpty(positioning)) {

            log.info("positioning is :" + positioning);

            return OrdersErrorCode.positioningIsEmpty.getValue();

        }

        if (DataUtils.isNullOrEmpty(lesseeServiceFee)) {

            log.info("lesseeServiceFee is :" + lesseeServiceFee);

            return OrdersErrorCode.lesseeServiceFeeIsEmpty.getValue();

        }

        if (DataUtils.isNullOrEmpty(lessorServiceFee)) {

            log.info("lessorServiceFee is :" + lessorServiceFee);

            return OrdersErrorCode.lessorServiceFeeIsEmpty.getValue();

        }

        return 0;

    }

}
