package com.ptteng.rent.user.utils;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.rent.user.model.Orders;
import com.ptteng.rent.user.service.OrdersService;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @author ss127
 * @date 2018/6/7
 */
public class OrderUtils {

    private static final Log log = LogFactory.getLog(OrderUtils.class);

    @Autowired
    private OrdersService ordersService;

    private static OrderUtils orderUtils;

    @PostConstruct
    public void init() {

        orderUtils = this;

    }

    /**
     * 返回唯一订单号
     *
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public static String getOrderNumber() throws ServiceException, ServiceDaoException {

        String orderNumber = generateCode();

        log.info("order number is :" + orderNumber);

        Map<String, Object> orderParams = DynamicUtil.getOidByOrderNumber(orderNumber);

        log.info("order params is :" + orderParams);

        List<Long> oids = new ArrayList<>();

        try {

            oids = orderUtils.ordersService.getIdsByDynamicCondition(Orders.class, orderParams, 0, 10);

        } catch (NullPointerException n) {

            return orderNumber;

        }


        if (CollectionUtils.isNotEmpty(oids)) {

            log.info("oids is :" + oids.get(0));

            return getOrderNumber();

        }

        return orderNumber;

    }

    /**
     * 生成订单号
     *
     * @return
     */
    private static String generateCode() {
        // 14位日期
        Long now = Long.parseLong(new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        // 随机码3位
        int num = (int) (Math.random() * 900) + 100;

        return now.toString() + Integer.toString(num);
    }


}
