package com.ptteng.rent.user.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.rent.admin.model.Constant;
import com.ptteng.rent.admin.model.Manager;
import com.ptteng.rent.admin.service.ConstantService;
import com.ptteng.rent.admin.service.ManagerService;
import com.ptteng.rent.common.model.Sms;
import com.ptteng.rent.common.service.SmsService;
import com.ptteng.rent.user.constant.SmsCodeConstant;
import com.ptteng.rent.user.constant.WxConfig;
import com.ptteng.rent.user.model.User;
import com.ptteng.rent.user.model.Verified;
import com.ptteng.rent.user.service.UserFollowRelationService;
import com.ptteng.rent.user.service.UserService;
import com.ptteng.rent.user.service.VerifiedService;
import com.ptteng.rent.user.utils.DynamicUtil;
import com.ptteng.rent.user.utils.ShowApiResultUtils;
import com.ptteng.rent.user.utils.UserAgeUtil;
import com.ptteng.rent.user.utils.UserVerifiedModel;
import com.ptteng.rent.user.utils.wx.ImgStorageTencentV4;
import com.qding.common.util.DataUtils;
import com.qding.common.util.FileUtil;
import com.qding.common.util.HttpClientUtil;
import com.qding.common.util.http.cookie.IdentityUtil;
import com.qding.community.common.weixin.service.WeiXinService;
import com.qding.community.common.weixin.vo.JSAPI;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * User  crud
 *
 * @author ss127
 * @date 2018/6/7
 */
@Controller
public class UserController {
    private static final Log log = LogFactory.getLog(UserController.class);

    @Autowired
    private UserService userService;
    @Autowired
    private HttpClientUtil httpClientUtil;
    @Autowired
    private SmsService smsService;
    @Resource(name = "accountConfig")
    private Map<String, String> accountConfig;
    @Autowired
    private ManagerService managerService;
    @Autowired
    private WeiXinService weixinService;
    @Autowired
    private ImgStorageTencentV4 imgStorageTencentV4;
    @Autowired
    private UserFollowRelationService userFollowRelationService;
    @Autowired
    private VerifiedService verifiedService;
    @Autowired
    private ConstantService constantService;

    @RequestMapping(value = "/a/u/img/{module}", method = RequestMethod.POST)
    public String uploadFile(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model,
                             @RequestParam MultipartFile file, @PathVariable String module)
            throws Exception {
        log.info("hello upload " + module);
        if (StringUtils.isNotBlank(module)) {
            module = "lessee";
        }
        int code = 0;
        log.info(file.getOriginalFilename());

        try {
            String type = file.getContentType();
            long size = file.getSize();
            log.info("  size is =" + size / 1048576);
            String extend = FileUtil.getFileExtension(file.getOriginalFilename());

            String fileName = UUID.randomUUID().toString() + "." + extend;
            log.info("new name is " + fileName);
            String filePath = "/data/temp/" + fileName;

            File tempPic = new File(filePath);
            file.transferTo(tempPic);


            String url = imgStorageTencentV4.imgStorage(module, fileName, filePath);
            log.info(module + " upload success ,and file name is " + fileName + "temp path is " + filePath
                    + " access url is " + url);
            tempPic.delete();
            log.info(file.getOriginalFilename() + " delete success ");
            model.addAttribute("url", url);
            model.addAttribute("code", 0);
            return "/common/img";
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            return "/common/success";
        }

    }

    /**
     * 网址接入
     *
     * @param model
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/wx", method = RequestMethod.GET)
    public String doGet(HttpServletRequest request, ModelMap model, HttpServletResponse response, String signature,
                        String timestamp, String nonce, String echostr) throws Exception {

        log.info("-------------------access weixin start-----------------------");

        log.info("signature=" + signature + ", timestamp=" + timestamp + ",nonce=" + nonce + ",echostr=" + echostr);

        if (null != timestamp && null != nonce && null != echostr && null != signature

                && weixinService.access(WxConfig.token, signature, timestamp, nonce)) {

        } else {

            log.warn("请求来源校验失败, signature=" + signature + ", timestamp=" + timestamp + ",nonce=" + nonce);

        }

        log.info(echostr);

        log.info("-------------------access weixin end-----------------------");

        model.addAttribute("echostr", echostr);

        return "/weixin/token/show";
    }

    @RequestMapping(value = "/a/wx/test", method = RequestMethod.GET)
    public String getOrdersIdsByStatusList1(HttpServletRequest request,
                                            HttpServletResponse response, ModelMap model, Integer status) throws Exception {

//        String sendWxMessage = AppletSendMessage.orderEndMessage("o8LL50FGqi_oHEYVJ9R8zVZnFtxs", "1000");
//        AppletSendMessage.payOrderSuccess();

        String result = httpClientUtil.sendGetRequest("https://dev.rent.home.ptteng.com/a/user/list?size=1", "UTF-8");

        log.info("result is :" + result);

//        String sendWxMessage = AppletSendMessage.newOrderMessage("o8LL50LbiPtoXtJ1sVm1hIe0W4PE","hello",
//                "34895793847534","999",395L,395L);
//        weixinService.updateAccessToken();
////
//        String result = weixinService.sendAppletMessage(WxConfig.appID, WxConfig.appSecret, sendWxMessage, true);
////
//        log.info("wx message send result is :" + result);


        return "/rent-user-service/orders/view/ordersList";
    }


    /**
     * @param request
     * @param response
     * @param model
     * @param mobile   手机号
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     * @Description :验证码发送
     */
    @RequestMapping(value = "/a/code/send", method = RequestMethod.POST)
    public String sendVerify(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model, String mobile) throws ServiceException, ServiceDaoException {

        log.info("-----------------------send code start------------------------");

        log.info(mobile + " want send sms of type ");

        String type = "register";

        if (StringUtils.isBlank(mobile)) {

            log.info(mobile + " want send sms of type " + type + " null mobile ");

            model.addAttribute("code", -2000);

            return "/common/success";

        }

        int code = SmsCodeConstant.System_Success;

        try {

            log.info("sms is start");

            String result = this.smsService.sendMsg(mobile, type);

            switch (result) {

                case SmsService.ErrorCode_SMS_InvalidType:

                    code = SmsCodeConstant.VerifyCode_Type_NotSupport;

                    break;

                case SmsService.ErrorCode_SMS_smsMoreThan5:

                    code = SmsCodeConstant.VerifyCode_MoreThan5;

                    break;

                default:

            }

            log.info("-----------------------send code end------------------------");

            model.addAttribute("code", code);

        } catch (Exception t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(mobile + " send message error of type " + type);
            model.addAttribute("code", SmsCodeConstant.System_Exception);
        }

        return "/common/success";

    }

    /**
     * @param request
     * @param model
     * @param response
     * @param code
     * @return
     * @throws Exception
     * @Description :查询用户是否注册登录
     */
    @RequestMapping(value = "/a/wx/openid", method = RequestMethod.POST)
    public String getOpenId(HttpServletRequest request, ModelMap model, HttpServletResponse response, String code) throws Exception {

        log.info("---------------------------search user yes or no registered start---------------------------------");

        log.info("code is :" + code);

        try {

            // 获取openID
            String openId = weixinService.getOpenID(WxConfig.appID, WxConfig.appSecret, code);

            log.info("openId is :" + openId);

            if (DataUtils.isNullOrEmpty(openId)) {

                log.info("openId is null,code is error");

                model.addAttribute("code", -2003);

                return "/common/success";

            }

            Long uid = userService.getUserIdByOpenID(openId);

            log.info("uid is :" + uid);

            User user = userService.getObjectById(uid);

            if (DataUtils.isNullOrEmpty(user)) {

                log.info("uid is null,user not regist");

                model.addAttribute("code", -1008);

                model.addAttribute("openId", openId);

                return "/rent-user-service/user/json/loginByOpid";

            }

            Integer loginStatus = user.getLoginStatus();

            log.info("loginStatus is :" + loginStatus);

            if (User.NOT_LOGIN.equals(loginStatus)) {

                log.info("user is not login ");

                model.addAttribute("code", -1009);

                model.addAttribute("openId", openId);

                return "/rent-user-service/user/json/loginByOpid";

            }

            String token = IdentityUtil.encodeCookie("phone", uid);

            log.info("token is ；" + token);

            log.info("---------------------------search user yes or no registered end---------------------------------");

            model.addAttribute("code", 0);
            model.addAttribute("user", user);
            model.addAttribute("token", token);

        } catch (Exception t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -6002);

        }

        return "/rent-user-service/user/json/checkLogin";
    }


    /**
     * @param request
     * @param response
     * @param modelMap
     * @param mobile
     * @param verify
     * @return
     * @throws Exception
     * @Description :登录注册
     */
    @RequestMapping(value = "/a/login", method = RequestMethod.POST)
    public String addUserJson(HttpServletRequest request,
                              HttpServletResponse response, ModelMap modelMap, String mobile, String verify, String
                                      code) throws Exception {

        log.info("--------------------------user registered login start----------------------------");

        log.info("mobile is:" + mobile + " verify is:" + verify + " code:" + code);

        try {

            if (DataUtils.isNullOrEmpty(mobile)) {

                log.info("mobile is null");

                modelMap.addAttribute("code", -2000);

                return "/common/success";
            }

            if (DataUtils.isNullOrEmpty(verify)) {

                log.info("message is null");

                modelMap.addAttribute("code", -2001);

                return "/common/success";
            }

            if (DataUtils.isNullOrEmpty(code)) {

                log.info("code is null");

                modelMap.addAttribute("code", -2025);

                return "/common/success";
            }


            /**
             * @Description :校验验证码
             */
            String type = "register";

            boolean verifyResult = false;

            if (verifyModel()) {
                log.info("is test model ");

                if ("555555".equals(verify)) {

                    log.info("test ,so not verify mobile ");

                    verifyResult = true;

                } else {

                    log.info("log1: mobile is " + mobile + ",type = " + type + ",verify" + verify);

                    verifyResult = verifyMobileCode(modelMap, mobile, type, verify);

                }
            } else {

                log.info("log1: mobile is " + mobile + ",type = " + type + ",verify" + verify);

                verifyResult = verifyMobileCode(modelMap, mobile, type, verify);
            }

            // 获取openID
            String openId = weixinService.getAppletOpenID(WxConfig.appID, WxConfig.appSecret, code);

            log.info("openId is :" + openId);

            if (DataUtils.isNullOrEmpty(openId)) {

                log.info("openId is null,code is error");

                modelMap.addAttribute("code", -2003);

                return "/common/success";

            }

            if (verifyResult) {

                /**
                 * @Description:查验手机号是否注册
                 */
                Long uid = userService.getUserIdByMobile(mobile);

                log.info("uid is :" + uid);

                if (DataUtils.isNullOrEmpty(uid)) {

                    log.info("The phone number:" + mobile + " is not registered");

                    User user = new User();

                    user.setMobile(mobile);

                    user.setOpenID(openId);

                    user.setUserType(User.UNKNOWN);

                    user.setUserStatus(User.USER_STATUS_AUTHORIZED);

                    user.setStatus(User.STATUS_OFF);

                    user.setTag(User.CITY);

                    user.setIsBullet(User.BULLET);

                    user.setLoginStatus(User.LOGIN);

                    user.setNewOrders(User.NEW_ORDER_AND_STATUS);

                    user.setOrdersStatus(User.NEW_ORDER_AND_STATUS);

                    uid = userService.insert(user);

                    log.info("uid is :" + uid);

                } else {

                    log.info("user is registered");

                    log.info("uid is :" + uid);

                    User user = userService.getObjectById(uid);

                    if (DataUtils.isNullOrEmpty(user)) {

                        log.info("user is not exist.");

                        modelMap.addAttribute("code", -2011);

                        return "/common/success";

                    }

                    user.setLoginStatus(User.LOGIN);

                    user.setOpenID(openId);

                    userService.update(user);

                }

                String token = IdentityUtil.encodeCookie("phone", uid);

                log.info("--------------------------user registered login end----------------------------");

                modelMap.addAttribute("code", 0);
                modelMap.addAttribute("uid", uid);
                modelMap.addAttribute("token", token);

            } else {

                log.error("wrong verifycode");

                modelMap.addAttribute("code", -1006);

                return "/common/success";

            }


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add user error ");
            modelMap.addAttribute("code", -6002);
        }

        return "/rent-user-service/user/json/login";
    }


    /**
     * 选择身份
     *
     * @param request
     * @param response
     * @param model
     * @param id       用户ID
     * @param type     用户身份
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/user/{id}/identity/{type}", method = RequestMethod.PUT)
    public String updateUserType(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, @PathVariable Long id, @PathVariable Integer type, Long recommenderId) throws Exception {

        log.info("url is : /a/u/user/" + id + "/identity/" + type + "?recommenderId=" + recommenderId);

        if (DataUtils.isNullOrEmpty(id)) {

            log.info("user id is :" + id);

            model.addAttribute("code", -2033);

            return "/common/success";

        }

        if (DataUtils.isNullOrEmpty(type)) {

            log.info("user type is :" + type);

            model.addAttribute("code", -2012);

            return "/common/success";

        }

        try {

            User user = userService.getObjectById(id);

            if (DataUtils.isNullOrEmpty(user)) {

                log.info("user is not exist.");

                model.addAttribute("code", -2011);

                return "/common/success";

            }

            Integer userType = user.getUserType();

            log.info("user type is :" + userType);

            if (userType.equals(User.UNKNOWN)) {

                if (type.equals(User.LESSEE)) {

                    user.setUserType(type);

                } else if (type.equals(User.LESSOR)) {

                    user.setUserType(type);

                    if (DataUtils.isNotNullOrEmpty(recommenderId)) {

                        Manager manager = managerService.getObjectById(recommenderId);

                        if (DataUtils.isNotNullOrEmpty(manager)) {

                            user.setRecommenderId(recommenderId);

                        }else {

                            log.info("manager is null");

                            model.addAttribute("code", -6012);

                            return "/common/success";

                        }

                    }

                    Map<String, Object> paramList = DynamicUtil.getConstantListParam("toll", "toll", null,
                            null,
                            null,
                            null, null, null, null, false);
                    log.info(" paramList size =  " + paramList.size());

                    List<Long> constantIdList = constantService.getIdsByDynamicCondition(Constant.class, paramList,
                            0, 10);

                    log.info("constantIdList size is :" + constantIdList.size());

                    if (CollectionUtils.isNotEmpty(constantIdList)) {

                        Constant constant = constantService.getObjectById(constantIdList.get(0));

                        user.setFeeCap(constant.getValue());

                    }


                } else {

                    log.info("type Illegal parameters");

                    model.addAttribute("code", -2013);

                    return "/common/success";

                }

            }

            boolean b = userService.update(user);

            if (b) {

                log.info("user update type is success");

            } else {

                log.info("user update type is fail");

                model.addAttribute("code", -6003);

                return "/common/success";

            }


            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update user error,id is  " + id);
            model.addAttribute("code", -6003);

        }

        return "/common/success";
    }

    /**
     * 用户详情
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/user/{id}", method = RequestMethod.GET)
    public String getUser(HttpServletRequest request,
                          HttpServletResponse response, ModelMap model, @PathVariable Long id, Long lesseeId)
            throws Exception {

        log.info("url is : /a/u/user/" + id);

        if (DataUtils.isNullOrEmpty(id)) {

            log.info("user id is :" + id);

            model.addAttribute("code", -2033);

            return "/common/success";

        }

        try {

            User user = userService.getObjectById(id);

            if (DataUtils.isNullOrEmpty(user)) {

                log.info("user is null");

                model.addAttribute("code", -2011);

                return "/common/success";

            }

            Long userFollowId = null;

            // 游客统统弹窗,没游客默认值
            Integer isBullet = 1;

            if (DataUtils.isNotNullOrEmpty(lesseeId)) {

                User lessee = userService.getObjectById(lesseeId);

                if (DataUtils.isNotNullOrEmpty(lessee)) {

                    log.info("lessor is not null");

                    userFollowId = userFollowRelationService.getUserFollowRelationIdByLessorIdAndLesseeId(id, lesseeId);

                    // 用户须知用户是否勾选不再提示
                    if (User.NOT_BULLET.equals(lessee.getIsBullet())) {

                        isBullet = User.NOT_BULLET;

                    } else {

                        Long userNoticeAt = lessee.getUserNoticeAt();

                        log.info("user notice time is :" + userNoticeAt);

                        if (DataUtils.isNotNullOrEmpty(userNoticeAt)) {

                            Long currentTime = System.currentTimeMillis();

                            Long differenceTime = currentTime - userNoticeAt;

                            // 弹窗间隔是否超过24小时
                            if (differenceTime > User.ONE_DAY_MILL) {

                                isBullet = User.BULLET;

                                lessee.setUserNoticeAt(System.currentTimeMillis());

                                userService.update(lessee);

                            } else {

                                isBullet = User.NOT_BULLET;

                            }

                        } else if (DataUtils.isNullOrEmpty(userNoticeAt)){

                            lessee.setUserNoticeAt(System.currentTimeMillis());

                            isBullet = User.BULLET;

                            userService.update(lessee);

                        }

                    }
                }

            }

            log.info("user follow id is ；" + userFollowId);

            Integer isFollow = User.IS_NOT_FOLLOW;

            if (DataUtils.isNotNullOrEmpty(userFollowId)) {

                isFollow = User.IS_FOLLOW;

            }

            model.addAttribute("code", 0);
            model.addAttribute("user", user);
            model.addAttribute("isFollow", isFollow);
            model.addAttribute("isBullet", isBullet);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -6003);
        }

        return "/rent-user-service/user/json/userDetailJson";
    }


    private boolean verifyModel() {

        return "test".equals(this.accountConfig.get("testModel"));

    }

     /**
     * @param request
     * @param response
     * @param model
     * @param url
     * @return
     * @Description 获取签名
     */
    @RequestMapping(value = "/a/wx/signature", method = RequestMethod.GET)
    public String updateToken(HttpServletRequest request, HttpServletResponse response, ModelMap model, String url) {

        log.info("---------------------------get the signature start---------------------------");

        log.info("usl is :" + url);

        try {

            weixinService.updateAccessToken();

            JSAPI jsapi = weixinService.getJSAPI(null, null, url);

            log.info("url " + url + " get JSAPI success :" + jsapi);

            log.info("---------------------------get the signature end---------------------------");

            model.addAttribute("code", 0);
            model.addAttribute("jsapi", jsapi);

        } catch (Throwable t) {
            log.error("get signature info error");
            t.printStackTrace();
        }
        return "/weixin/jsapi/show";

    }




    /**
     * 编辑用户
     *
     * @param request
     * @param response
     * @param model
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/user/{id}", method = RequestMethod.PUT)
    public String updateUserJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, @PathVariable Long id, String nick, String avatar, String permanentAddress, Long age
            , Integer height, Integer weight, String hobby, String schedule, String WeChat, String skill, String toll,String coverUrl,
                                 String
                                         videoUrl, String imgUrl, Integer sex, Integer isBullet) throws Exception {

        log.info("url is : /a/u/user/" + id + "?nick=" + nick + "&avatar=" + avatar + "&permanentAddress=" + permanentAddress + "&age=" + age + "&height=" + height + "&hobby=" + hobby
                + "&schedule=" + schedule + "&WeChat=" + WeChat + "&skill=" + skill + "&toll=" + toll + "&videoUrl="
                + videoUrl + "&imgUrl=" + imgUrl + "&weight" + weight + "$sex=" + sex + "&isBullet=" + isBullet+"&coverUrl="+coverUrl);

        try {

            User user = userService.getObjectById(id);

            if (DataUtils.isNullOrEmpty(user)) {

                log.info("user is null");

                model.addAttribute("code", -2011);

                return "/common/success";

            }

            if (DataUtils.isNotNullOrEmpty(nick)) {

                Long uid = userService.getUserIdByNick(nick);

                log.info("get user by nick uid is :" + uid);

                if (DataUtils.isNotNullOrEmpty(uid)) {

                    log.info("user is null");
//                    user.setNick(nick+""+uid);

//                    model.addAttribute("code", -2024);
//
//                    return "/common/success";

                }
                user.setNick(nick);




            }

            if (DataUtils.isNotNullOrEmpty(weight)) {

                user.setWeight(weight);

            }


            if (DataUtils.isNotNullOrEmpty(avatar)) {

                user.setAvatar(avatar);

            }

            if (DataUtils.isNotNullOrEmpty(permanentAddress)) {

                user.setPermanentAddress(permanentAddress);

            }

            if (DataUtils.isNotNullOrEmpty(age)) {

                user.setAge(age);

            }

            if (DataUtils.isNotNullOrEmpty(height)) {

                user.setHeight(height);

            }
            if (DataUtils.isNotNullOrEmpty(coverUrl)) {

                user.setCoverUrl(coverUrl);

            }

            if (DataUtils.isNotNullOrEmpty(hobby)) {

                user.setHobby(hobby);

            }

            if (DataUtils.isNotNullOrEmpty(schedule)) {

                user.setSchedule(schedule);

            }

            if (DataUtils.isNotNullOrEmpty(WeChat)) {

                user.setWeChat(WeChat);

            }

            if (DataUtils.isNotNullOrEmpty(skill)) {

                user.setSkill(skill);

            }

            if (DataUtils.isNotNullOrEmpty(toll)) {

                if (User.MIN_CHARGE > Integer.valueOf(toll)) {

                    log.info("Cannot be less than 1");

                    model.addAttribute("code", -2023);

                    return "/common/success";

                }

                user.setToll(toll);

            }

            if (DataUtils.isNotNullOrEmpty(videoUrl)) {

                user.setVideoUrl(videoUrl);

            }

            if (DataUtils.isNotNullOrEmpty(imgUrl)) {

                user.setImgUrl(imgUrl);

            }

            if (DataUtils.isNotNullOrEmpty(sex)) {

                if (DataUtils.isNullOrEmpty(user.getSex())) {

                    user.setSex(sex);

                }

            }

            if (DataUtils.isNotNullOrEmpty(isBullet)) {

                if (User.NOT_BULLET.equals(isBullet)) {

                    user.setIsBullet(isBullet);

                }

            }

            boolean b = userService.update(user);

            if (b) {

                log.info("user update type is success");

            } else {

                log.info("user update type is fail");

                model.addAttribute("code", -6003);

                return "/common/success";

            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update user error,id is  " + id);
            model.addAttribute("code", -6003);
        }

        return "/common/success";
    }


    /**
     * 首页用户列表
     *
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @param sex         性别
     * @param tag         标签
     * @param positioning 定位
     * @param sort        换一换（变换用户排序）
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/user/list", method = RequestMethod.GET)
    public String getUserList¢(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model, Integer page,
                               Integer size, Integer sex, String tag, String positioning, Integer sort) throws Exception {

        log.info("url is :/a/u/user/list?sex=" + sex + "&tag=" + tag + "&positioning=" + positioning + "&page=" +
                page + "&size=" + size + "&sort=" + sort);

        if (page == null) {

            page = 1;

        }

        if (size == null) {

            size = 10;

        }

        int start = (page - 1) * size;

        if (start < 0) {

            start = 0;

        }

        boolean next = false;

        Integer total = 0;

        try {

            Map<String, Object> usersParams = DynamicUtil.getUserListBySexAndTagAndPosing(sex, tag, positioning, sort, false);

            log.info("usersParams is :" + usersParams);

            List<Long> uids = userService.getIdsByDynamicCondition(User.class, usersParams, start, size);

            log.info("uid is :" + uids);


            List<User> userList = new ArrayList<>();

            if (CollectionUtils.isNotEmpty(uids)) {

                // 换一换
                shuffle(uids);

                userList = userService.getObjectsByIds(uids);

                if (userList.size() >= size) {

                    next = true;

                }

            }

            Map<String, Object> countUserParam = DynamicUtil.getUserListBySexAndTagAndPosing(sex, tag, positioning, sort, true);

            log.info("countUserParam is :" + countUserParam);

            List<Long> countUids = userService.getIdsByDynamicCondition(User.class, usersParams, 0, Integer.MAX_VALUE);

            if (CollectionUtils.isNotEmpty(countUids)) {

                total = countUids.size();

                log.info("user total is :" + total);

            }

            log.info("countUids size is :" + countUids.size());

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("next", next);
            model.addAttribute("userList", userList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/rent-user-service/user/json/userListJson";
    }


    /**
     * 实名认证
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @param name     真实姓名
     * @param IDNumber 身份证号
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/user/{id}/verified", method = RequestMethod.PUT)
    public String login(HttpServletRequest request,
                            HttpServletResponse response, ModelMap model, @PathVariable Long id, String name, String IDNumber) throws Exception {

        log.info("/a/u/user/" + id + "/verified");

        if (DataUtils.isNullOrEmpty(name)) {

            log.info("name is :" + name);

            model.addAttribute("code", -2014);

            return "/common/success";

        }


        if (DataUtils.isNullOrEmpty(IDNumber)) {

            log.info("IDNumber is :" + IDNumber);

            model.addAttribute("code", -2015);

            return "/common/success";

        }

        int age = UserAgeUtil.getAge(IDNumber, "yyyyMMdd");

        log.info("user age is :" + age);

        if (User.ADULT > age) {

            log.info("user is less 18");

            model.addAttribute("code", -2018);

            return "/common/success";

        }

        try {

            User user = userService.getObjectById(id);

            if (DataUtils.isNullOrEmpty(user)) {

                log.info("user is null");

                model.addAttribute("code", -2011);

                return "/common/success";

            }

            Integer userStatus = user.getUserStatus();

            log.info("user status is :" + userStatus);

            if (User.USER_STATUS_VERIFIED.equals(userStatus)) {

                log.info("The user has already been authenticated");

                model.addAttribute("code", -2021);

                return "/common/success";

            }

            Long vid = verifiedService.getVerifiedIdByUid(id);

            Verified verified;

            log.info("vid is :" + vid);

            if (DataUtils.isNotNullOrEmpty(vid)) {

                verified = verifiedService.getObjectById(vid);

                Format formatter = new SimpleDateFormat("d");

                String ftime = formatter.format(System.currentTimeMillis());

                log.info("current time millis is :" + ftime);

                String stime = formatter.format(verified.getSendAt());

                log.info("verified time is :" + stime);

                if (!ftime.equals(stime)) {

                    verified.setCount(0);

                }

                if (verified.getCount() < Verified.FAIL_COUNT) {

                    UserVerifiedModel userVerifiedModel = ShowApiResultUtils.getShowApiResultCode(name, IDNumber);

                    log.info("---------- result is :" + userVerifiedModel);

//{"showapi_res_error":"","showapi_res_code":0,"showapi_res_body":{"birthday":"1994-11-15","msg":"匹配","code":0,"sex":"M","address":"新疆维吾尔族自治区乌鲁木齐市乌鲁木齐县","ret_code":0}}
//{"showapi_res_error":"","showapi_res_code":0,"showapi_res_body":{"success":true,"data":{"code":101,"msg":"验证信息重复输入，避免恶意验证请间隔30秒以上再次核验","ret_code":-1,"error":"验证信息重复输入，避免恶意验证请间隔30秒以上再次核验"}}}
// {"showapi_res_error":"未找到可用资源包，请检查是否未订购套餐，或者当前调用量已为0。","showapi_res_code":-2,"showapi_res_body":{}}

                    int successCode = userVerifiedModel.getShowapi_res_body().getCode();

                    log.info("success code is :" + successCode);

                    int busyCode = userVerifiedModel.getShowapi_res_body().getCode();

                    log.info("busy code is :" + busyCode);

                    int errorCode = userVerifiedModel.getShowapi_res_code();

                    log.info("error code is :" + errorCode);

                    Long interval = System.currentTimeMillis() - verified.getSendAt();

                    log.info("interval is :" + interval);

                    if (Verified.INTERVAL > interval) {

                        log.info("The verification information is input repeatedly to avoid malicious verification. Please check again more than 30 seconds.");

                        model.addAttribute("code", -2022);

                        return "/common/success";

                    }

                    verified.setSendAt(System.currentTimeMillis());

                    // 实名认证次数加一
                    verified.setCount(verified.getCount() + 1);

                    boolean isVerify = verifiedService.update(verified);

                    if (isVerify) {

                        log.info("update verified is success");

                    } else {

                        log.info("update verified is fail");

                        model.addAttribute("code", -6003);

                        return "/common/success";

                    }

                    // 校验易源返回验证结果
                    if (Verified.SUCCESS == successCode && busyCode != Verified.BUSY_CODE && errorCode != Verified.ERROR_CODE) {

                        log.info("verified is success!");

                        user.setName(name);

                        user.setIDNumber(IDNumber);

                        user.setUserStatus(User.USER_STATUS_VERIFIED);

                        boolean b = userService.update(user);

                        if (b) {

                            log.info("user update verify is success");

                        } else {

                            log.info("user update verify is fail");

                            model.addAttribute("code", -6003);

                            return "/common/success";

                        }

                    } else {

                        log.info("verified is error");

                        model.addAttribute("code", -2020);

                        return "/common/success";

                    }

                } else {

                    log.info("The number of verifications is greater than three");

                    model.addAttribute("code", -2019);

                    return "/common/success";

                }

            } else {

                Verified newVerified = new Verified();

                newVerified.setCount(Verified.INIT);

                newVerified.setSendAt(System.currentTimeMillis());

                newVerified.setUid(id);

                Long newVerifiedId = verifiedService.insert(newVerified);

                UserVerifiedModel userVerifiedModel = ShowApiResultUtils.getShowApiResultCode(name, IDNumber);

                log.info("---------- result is :" + userVerifiedModel);

                log.info("new verified id is :" + newVerifiedId);

                int successCode = userVerifiedModel.getShowapi_res_body().getCode();

                log.info("success code is :" + successCode);

                int busyCode = userVerifiedModel.getShowapi_res_body().getCode();

                log.info("busy code is :" + busyCode);

                int errorCode = userVerifiedModel.getShowapi_res_code();

                log.info("error code is :" + errorCode);

                // 校验易源返回验证结果
                if (Verified.SUCCESS == successCode && busyCode != Verified.BUSY_CODE && errorCode != Verified.ERROR_CODE) {

                    log.info("verified is success!");

                    user.setName(name);

                    user.setIDNumber(IDNumber);

                    user.setUserStatus(User.USER_STATUS_VERIFIED);

                    boolean b = userService.update(user);

                    if (b) {

                        log.info("user update verify is success");

                    } else {

                        log.info("user update verify is fail");

                        model.addAttribute("code", -6003);

                        return "/common/success";

                    }
                } else {

                    log.info("verified is error");

                    model.addAttribute("code", -2020);

                    return "/common/success";

                }

            }


            model.addAttribute("code", 0);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/common/success";
    }

    /**
     * 更新用户当前定位
     *
     * @param request
     * @param response
     * @param model
     * @param uid         用户ID
     * @param positioning 当前定位城市
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/user/{uid}/position", method = RequestMethod.PUT)
    public String updateUserPosition(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, @PathVariable Long uid, String
                                             positioning, String area) throws Exception {

        log.info("url is : /a/u/user/" + uid + "/position?positioning=" + positioning + "&area=" + area);

        if (DataUtils.isNullOrEmpty(uid)) {

            log.info("uid is null");

            model.addAttribute("code", -2033);

            return "/common/success";

        }

        if (DataUtils.isNullOrEmpty(positioning)) {

            log.info("positioning is null");

            model.addAttribute("code", -2016);

            return "/common/success";

        }

        try {

            User user = userService.getObjectById(uid);

            if (DataUtils.isNullOrEmpty(user)) {

                log.info("user is null");

                model.addAttribute("code", -2011);

                return "/common/success";

            }

            user.setPositioning(positioning);

            user.setArea(area);

            boolean b = userService.update(user);

            if (b) {

                log.info("user update positioning is success");

            } else {

                log.info("user update positioning is fail");

                model.addAttribute("code", -6003);

                return "/common/success";

            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/common/success";

    }

    /**
     * 用户手动选择定位
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @param manuallySelectPositioning 手动选择定位
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/user/{id}/manually/positioning", method = RequestMethod.PUT)
    public String getManuallySelectPositioning(HttpServletRequest request,
                                               HttpServletResponse response, ModelMap model, @PathVariable Long id, String manuallySelectPositioning)
            throws Exception {

        log.info("url is : /a/u/user/" + id + "/manually/positioning?" + manuallySelectPositioning);

        if (DataUtils.isNullOrEmpty(id)) {

            log.info("user id is :" + id);

            model.addAttribute("code", -2033);

            return "/common/success";

        }

        if (DataUtils.isNullOrEmpty(manuallySelectPositioning)) {

            log.info("user manuallySelectPositioning is :" + manuallySelectPositioning);

            model.addAttribute("code", -2017);

            return "/common/success";

        }

        try {

            User user = userService.getObjectById(id);

            if (DataUtils.isNullOrEmpty(user)) {

                log.info("user is null");

                model.addAttribute("code", -2011);

                return "/common/success";

            }

            user.setManuallySelectPositioning(manuallySelectPositioning);

            boolean b = userService.update(user);

            if (b) {

                log.info("user update manuallySelectPositioning is success");

            } else {

                log.info("user update manuallySelectPositioning is fail");

                model.addAttribute("code", -6003);

                return "/common/success";

            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -6003);
        }

        return "/common/success";
    }


    /**
     * 退出登录
     *
     * @param request
     * @param response
     * @param model
     * @param uid
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/user/out/login", method = RequestMethod.PUT)
    public String userOutLogin(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model, Long uid) throws Exception {

        log.info("url is : /a/u/user/out/login?uid=" + uid);

        if (DataUtils.isNullOrEmpty(uid)) {

            log.info("uid is null");

            model.addAttribute("code", -2033);

            return "/common/success";

        }

        try {

            User user = userService.getObjectById(uid);

            if (DataUtils.isNullOrEmpty(user)) {

                log.info("user is null");

                model.addAttribute("code", -2011);

                return "/common/success";

            }

            user.setLoginStatus(User.NOT_LOGIN);

            user.setPositioning(null);

            user.setArea(null);

            boolean b = userService.update(user);

            if (b) {

                log.info("user update loginStatus is success");

            } else {

                log.info("user update loginStatus is fail");

                model.addAttribute("code", -6003);

                return "/common/success";

            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/common/success";

    }


    /**
     * 验证码校验
     *
     * @param modelMap
     * @param mobile   手机号
     * @param type     类型
     * @param verify   验证码
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    private boolean verifyMobileCode(ModelMap modelMap, String mobile, String type,
                                     String verify) throws ServiceException, ServiceDaoException {
        log.info("log2: mobile is " + mobile + ",type = " + type + ",verify" + verify);

        // 是否有发送验证码
        Long sid = smsService.getSmsIdByMobileAndType(mobile, type);

        log.info("sid is " + sid);

        if (sid == null) {

            return false;

        }
        // 获取验证码信息
        Sms sms = smsService.getObjectById(sid);

        log.info("sms is " + sms);
        // 获取验证码
        String message = sms.getMessage();

        log.info("message is " + message);

        //发送是否超时
        Long delay = System.currentTimeMillis() - sms.getSendAt();

        if (delay > 600000) {

            log.info("require verify too long");

            return false;
        }

        if (message.equals(verify)) {

            return true;

        } else {

            return false;

        }

    }

    @RequestMapping(value = "/a/login/statusOff", method = RequestMethod.GET)
    public String testLongin(HttpServletRequest request, HttpServletResponse response, ModelMap model, String url) {

        log.info("---------------------------get the login test start---------------------------");


        try {

            log.info("===============================FUCK=============================================");
            model.addAttribute("code", -3);

            log.info("===============================FUCK=============================================");

        } catch (Throwable t) {
            log.error("get signature info error");
            t.printStackTrace();
        }
        return "/common/success";

    }


    /**
     * 用户idList
     *
     * @param list
     * @param <T>
     */
    private <T> void shuffle(List<T> list) {
        int size = list.size();
        Random random = new Random();

        for (int i = 0; i < size; i++) {
            // 获取随机位置
            int randomPos = random.nextInt(size);

            // 当前元素与随机元素交换
            T temp = list.get(i);
            list.set(i, list.get(randomPos));
            list.set(randomPos, temp);
        }
    }

}

