package com.ptteng.rent.user.utils;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class UserAgeUtil {


    private static int getAge(Date birthDay) throws Exception {

        Calendar cal = Calendar.getInstance();

        if (cal.before(birthDay)) {
            return 0;
        }

        int yearNow = cal.get(Calendar.YEAR);
        int monthNow = cal.get(Calendar.MONTH);
        int dayOfMonthNow = cal.get(Calendar.DAY_OF_MONTH);
        cal.setTime(birthDay);

        int yearBirth = cal.get(Calendar.YEAR);
        int monthBirth = cal.get(Calendar.MONTH);
        int dayOfMonthBirth = cal.get(Calendar.DAY_OF_MONTH);

        int age = yearNow - yearBirth;

        if (monthNow <= monthBirth) {
            if (monthNow == monthBirth) {
                if (dayOfMonthNow < dayOfMonthBirth) {
                    age--;
                }
            } else {
                age--;
            }
        }

        return age;
    }

    /**
     * 根据出生日期计算年龄
     *
     * @param IDNumber
     *            身份证号
     * @param format
     *            日期格式
     * @return 未来日期返回0
     * @throws Exception
     */
    public static int getAge(String IDNumber, String format)
            throws Exception {

        String birthday = IDNumber.substring(6, 14);

        DateFormat df = new SimpleDateFormat(format);
        Date birthDay = df.parse(birthday);
        return getAge(birthDay);
    }

}
