package com.ptteng.rent.user.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.gemantic.common.util.MyListUtil;
import com.ptteng.rent.user.model.User;
import com.ptteng.rent.user.service.UserService;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.rent.user.model.UserFollowRelation;
import com.ptteng.rent.user.service.UserFollowRelationService;

/**
 * UserFollowRelation  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class UserFollowRelationController {
	private static final Log log = LogFactory.getLog(UserFollowRelationController.class);

	@Autowired
	private UserFollowRelationService userFollowRelationService;
	@Autowired
	private UserService userService;


	/**
	 * 关注出租人
	 * @param request
	 * @param response
	 * @param model
	 * @param id        承租人id
	 * @param lessorId  出租人id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/user/{id}/follow", method = RequestMethod.POST)
	public String addUserFollowRelationJson(HttpServletRequest request,
											HttpServletResponse response, ModelMap model, @PathVariable Long id,Long lessorId)
			throws Exception {

		log.info("/a/u/user/"+ id +"/follow?lessorId=" + lessorId);

		try {

			UserFollowRelation userFollowRelation = new UserFollowRelation();

			userFollowRelation.setLesseeId(id);

			userFollowRelation.setLessorId(lessorId);

			Long followId = userFollowRelationService.getUserFollowRelationIdByLessorIdAndLesseeId(lessorId, id);

			log.info("followId is :" + followId);

			if (DataUtils.isNotNullOrEmpty(followId)) {

				log.info("repeat follow");

				model.addAttribute("code", -5000);

				return "/common/success";

			}

			User lessee = userService.getObjectById(id);

			if (DataUtils.isNullOrEmpty(lessee)) {

				log.info("lessor is null");

				model.addAttribute("code", -2011);

				return "/common/success";

			}

			User lessor = userService.getObjectById(lessorId);

			if (DataUtils.isNullOrEmpty(lessor)) {

				log.info("lessor is null");

				model.addAttribute("code", -2011);

				return "/common/success";

			}

            Integer userType = lessor.getUserType();

			log.info("lessor id user type is :" + userType);

            if (User.LESSEE.equals(userType)) {

                log.info("lessee can not follow lessee.");

                model.addAttribute("code", -5001);

                return "/common/success";

            }

			if (DataUtils.isNullOrEmpty(lessor.getFollow())) {

            	// 脏数据初始化
            	lessor.setFollow(0);

			}

			// 承租人关注出租人，出租人关注数加一
			lessor.setFollow(lessor.getFollow() + User.PLUS_ONE);

			Long userFollowId = userFollowRelationService.insert(userFollowRelation);

			log.info("user follow id is :" + userFollowId);

			boolean b = userService.update(lessor);

			if (b) {

				log.info("lessor update follow is success");

			} else {

				log.info("lessor update follow is fail");

				model.addAttribute("code", -6003);

				return "/common/success";

			}

			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add userFollowRelation error ");
			model.addAttribute("code", -6002);
		}

		return "/common/success";
	}

	/**
	 * 取消关注
	 *
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @param lessorId 出租人id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/user/{id}/follow", method = RequestMethod.DELETE)
	public String cancelFollow(HttpServletRequest request,
							   HttpServletResponse response, ModelMap model, @PathVariable Long id, Long lessorId)
			throws Exception {

		log.info("url is : /a/u/user/" + id);

		if (DataUtils.isNullOrEmpty(id)) {

			log.info("user id is :" + id);

			model.addAttribute("code", -2033);

			return "/common/success";

		}

		try {

			User user = userService.getObjectById(id);

			if (DataUtils.isNullOrEmpty(user)) {

				log.info("user is null");

				model.addAttribute("code", -2011);

				return "/common/success";

			}

			Integer followers = user.getFollow();

			User lessor = userService.getObjectById(lessorId);

			if (DataUtils.isNullOrEmpty(lessor)) {

				log.info("lessor is null");

				model.addAttribute("code", -2011);

				return "/common/success";

			}

			Long userFollowId = userFollowRelationService.getUserFollowRelationIdByLessorIdAndLesseeId(lessorId, id);

			log.info("user follow id is ；" + userFollowId);


			if (DataUtils.isNotNullOrEmpty(userFollowId)) {

				boolean b = userFollowRelationService.delete(userFollowId);

				if (b) {

					log.info("cancel follow is success");

					// 关注数减一
					lessor.setFollow(lessor.getFollow() - User.PLUS_ONE);

					boolean userUpdate = userService.update(lessor);

					if (userUpdate) {

						log.info("user update type is success");

					} else {

						log.info("user update type is fail");

						model.addAttribute("code", -6003);

						return "/common/success";

					}


				} else {

					log.info("cancel follow is fail");

					model.addAttribute("code", -6003);

					return "/common/success";

				}

			}

			log.info("user followers is :" + followers);

			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			model.addAttribute("code", -6003);
		}

		return "/common/success";
	}

	/**
	 * 我的关注列表
	 *
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/user/{id}/follow", method = RequestMethod.GET)
	public String getUserFollow(HttpServletRequest request,
								HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

		log.info("url is :/a/u/user/" + id + "/follow");

		try {

			List<Long> userFollowIds = userFollowRelationService.getUserFollowRelationIdsByLesseeId(id, 0, Integer.MAX_VALUE);

			log.info("userFollow ids size is :" + userFollowIds.size());

			List<UserFollowRelation> userFollowRelationList = new ArrayList<>();

			if (CollectionUtils.isNotEmpty(userFollowIds)) {

				userFollowRelationList = userFollowRelationService.getObjectsByIds(userFollowIds);

			}

			List<Long> uids = MyListUtil.getDistinctList(UserFollowRelation.class.getDeclaredField("lessorId"), userFollowRelationList);

			log.info("uids size is :" + uids.size());

			List<User> userList = userService.getObjectsByIds(uids);

			model.addAttribute("code", 0);
			model.addAttribute("userList", userList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			model.addAttribute("code", -100000);
		}

		return "/rent-user-service/user/json/userListJson";
	}

	
}

