/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.pet.orderspush.etl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.sms.service.SMSSendService;
import com.ptteng.pet.orderspush.etl.constant.WxConstantConfig;
import com.ptteng.pet.orderspush.etl.util.DynamicUtil;
import com.ptteng.pet.universal.model.OrdersPush;
import com.ptteng.pet.universal.service.OrdersPushService;
import com.qding.community.common.weixin.service.WeiXinService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class OrdersPushEtl {
    private static final Log log = LogFactory.getLog(OrdersPushEtl.class);
    private OrdersPushService ordersPushService;
    @Autowired
    private WeiXinService weixinService;
    @Autowired
    private SMSSendService smsSendService;
    private static final int TASK_LEN = 100;
    private static final long SLEEP_MILLISECOND = 15000L;
    private Long interval = 2000L;

    public void process() throws InterruptedException {
        while (true) {
            try {
                while (true) {
                    log.info((Object)"etl is start!");
                    List<OrdersPush> ordersWxPushList = this.getWxOrdersPushList();
                    List<OrdersPush> ordersSmsPushList = this.getSmsOrdersPushList();
                    log.info((Object)("orders push for wx list size is :" + ordersWxPushList.size()));
                    log.info((Object)("orders push for sms list size is :" + ordersSmsPushList.size()));
                    if (CollectionUtils.isEmpty(ordersWxPushList) & CollectionUtils.isEmpty(ordersSmsPushList)) {
                        log.info((Object)"orders push etl not get any id ,sleep 15000 ms ");
                        Thread.sleep(15000L);
                    }
                    this.processOrder(ordersWxPushList, ordersSmsPushList);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                Thread.sleep(15000L);
                log.error((Object)("process goods bytime status error ,sleep " + t.getMessage()));
                continue;
            }
            break;
        }
    }

    private List<OrdersPush> getWxOrdersPushList() {
        log.info((Object)"look here!!!!");
        List<Object> ordersWxPushList = new ArrayList<OrdersPush>();
        Long current = System.currentTimeMillis();
        Integer type = OrdersPush.WEIXIN_TYPE;
        Map<String, Object> conditions = DynamicUtil.getOrdersPushListForWx(current, type);
        log.info((Object)("orders  wx push conditions is \uff1b" + conditions));
        try {
            List ordersPushIds = this.ordersPushService.getIdsByDynamicCondition(OrdersPush.class, conditions, Integer.valueOf(0), Integer.valueOf(100));
            if (CollectionUtils.isEmpty((Collection)ordersPushIds)) {
                log.info((Object)"not ger any process message ");
            } else {
                ordersWxPushList = this.ordersPushService.getObjectsByIds(ordersPushIds);
                log.info((Object)("get process orders push size is " + ordersPushIds.size()));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t);
        }
        return ordersWxPushList;
    }

    private List<OrdersPush> getSmsOrdersPushList() {
        log.info((Object)"look here!!!!");
        List<Object> ordersSmsPushList = new ArrayList<OrdersPush>();
        Long current = System.currentTimeMillis();
        Integer type = OrdersPush.SMS_TYPE;
        Map<String, Object> conditions = DynamicUtil.getOrdersPushListForWx(current, type);
        log.info((Object)("orders sms push conditions is \uff1b" + conditions));
        try {
            List ordersPushIds = this.ordersPushService.getIdsByDynamicCondition(OrdersPush.class, conditions, Integer.valueOf(0), Integer.valueOf(100));
            if (CollectionUtils.isEmpty((Collection)ordersPushIds)) {
                log.info((Object)"not ger any process message ");
            } else {
                ordersSmsPushList = this.ordersPushService.getObjectsByIds(ordersPushIds);
                log.info((Object)("get process orders push size is " + ordersPushIds.size()));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t);
        }
        return ordersSmsPushList;
    }

    private void processOrder(List<OrdersPush> ordersWxPushList, List<OrdersPush> ordersSmsPushList) throws ServiceException, ServiceDaoException, InterruptedException, IOException {
        log.info((Object)"hello world!!!");
        if (CollectionUtils.isEmpty(ordersWxPushList)) {
            log.info((Object)"no query wx orders push! ");
        } else {
            log.info((Object)(this.interval + " will query wx orders push size is " + ordersWxPushList.size()));
            for (OrdersPush ordersPush : ordersWxPushList) {
                String openId = ordersPush.getOpenId();
                log.info((Object)("user openid is :" + openId));
                String mobile = ordersPush.getAccount();
                log.info((Object)("user mobile is :" + mobile));
                String orderNo = ordersPush.getOrderNo();
                log.info((Object)("user order number is :" + orderNo));
                Long repaymentDateInit = ordersPush.getRepaymentDate();
                log.info((Object)("repayment data init is \uff1b" + repaymentDateInit));
                String repaymentDay = ordersPush.getRepaymentDay();
                log.info((Object)("repaymentDay is :" + repaymentDay));
                String repaymentAmount = ordersPush.getRepaymentAmount();
                log.info((Object)("user order repayment amount is :" + repaymentAmount));
                Long oid = ordersPush.getOid();
                log.info((Object)("oid is \uff1b" + oid));
                String sendWxMessage = "{  \n     \"touser\":\"" + openId + "\",\n     \"template_id\":\"yW-yHhLvU41t3t5cyKy0-GqfXmWF_6njMnDPCHCfyqY\",  \n     \"url\":\"https://open.weixin.qq.com/connect/oauth2/authorize?appid=wx37f81bab6101e630&redirect_uri=http://dev.pet.home.ptteng.com/detail/stagesDetail?id=" + oid + "&type=wx&response_type=code&scope=snsapi_userinfo&state=STATEvideogo&connect_redirect=1#wechat_redirect\",    \n     \"data\":{  \n             \"first\": {  \n                 \"value\":\"\u60a8\u597d\uff0c\u60a8\u6709\u4e00\u7b14\u8ba2\u5355\u9700\u8981\u8fd8\u6b3e\uff1a\",  \n                 \"color\":\"#173177\"  \n             },  \n             \"keyword1\":{  \n                 \"value\":\"" + mobile + "\",  \n                 \"color\":\"#173177\"  \n             },  \n             \"keyword2\": {  \n                 \"value\":\"" + orderNo + "\",  \n                 \"color\":\"#173177\"  \n             },  \n             \"keyword4\": {  \n                 \"value\":\"" + repaymentDay + "\",  \n                 \"color\":\"#173177\"  \n             },  \n             \"keyword5\": {  \n                 \"value\":\"" + repaymentAmount + "\u5143\",  \n                 \"color\":\"#173177\"  \n             },  \n             \"remark\":{  \n                 \"value\":\"\u8bf7\u8bb0\u5f97\u6309\u65f6\u4ed8\u6b3e\u54e6\uff01\",  \n                 \"color\":\"#173177\"  \n             }  \n     }  \n }  ";
                this.weixinService.updateAccessToken();
                String result = this.weixinService.sendTemplateMessage(WxConstantConfig.appID, WxConstantConfig.appSecret, sendWxMessage, true);
                log.info((Object)("wx message send result is :" + result));
                ordersPush.setStatus(OrdersPush.HAS_BEEN_SENT);
            }
            boolean b = this.ordersPushService.updateList(ordersWxPushList);
            if (b) {
                log.info((Object)"update success!");
            } else {
                log.info((Object)"update fial!");
            }
        }
        if (CollectionUtils.isEmpty(ordersSmsPushList)) {
            log.info((Object)"no query sms orders push! ");
        } else {
            log.info((Object)(this.interval + " will query sms orders push size is " + ordersSmsPushList.size()));
            for (OrdersPush ordersPush : ordersSmsPushList) {
                String mobile = ordersPush.getAccount();
                log.info((Object)("user mobile is :" + mobile));
                String repaymentAmount = ordersPush.getRepaymentAmount();
                log.info((Object)("repayment amount is :" + repaymentAmount));
                Long repaymentDateInit = ordersPush.getRepaymentDate();
                log.info((Object)("repayment data init is \uff1b" + repaymentDateInit));
                String formatRepaymentDay = ordersPush.getRepaymentDay();
                log.info((Object)("formatRepaymentDay is :" + formatRepaymentDay));
                String[] sendSmsMessage = new String[]{"\u3010\u701a\u661f\u4fe1\u606f\u3011\u5c0a\u656c\u7684\u987e\u5ba2\uff0c\u60a8\u5f53\u6708\u9700\u8fd8\u6b3e\u989d" + repaymentAmount + "\u5143\uff0c\u4e3a\u4e86\u4e0d\u5f71\u54cd\u60a8\u7684\u5f81\u4fe1\u8bb0\u5f55\uff0c\u8bf7\u4e8e" + formatRepaymentDay + "\u4e4b\u524d\u8fd8\u6b3e\uff0c\u5982\u6709\u95ee\u9898\uff0c\u8bf7\u8054\u7cfb\u60a8\u7684\u4e13\u804c\u5ba2\u670d400-888-666"};
                String resutl = this.smsSendService.sendSMSByTemplate(mobile, "", sendSmsMessage);
                log.info((Object)("=====================result" + resutl));
                ordersPush.setStatus(OrdersPush.HAS_BEEN_SENT);
            }
            boolean b = this.ordersPushService.updateList(ordersSmsPushList);
            if (b) {
                log.info((Object)"update success!");
            } else {
                log.info((Object)"update fial!");
            }
        }
    }

    public void setOrdersPushService(OrdersPushService ordersPushService) {
        this.ordersPushService = ordersPushService;
    }

    public OrdersPushService getOrdersPushService() {
        return this.ordersPushService;
    }

    public Long getInterval() {
        return this.interval;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }
}

