-- ----------------------------
-- Table structure for `property`
-- ----------------------------
-- DROP TABLE IF EXISTS `property`;
CREATE TABLE `property` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `classify_id` bigint NOT NULL   COMMENT '分类id',
    `title` varchar(50) NOT NULL   COMMENT '属性名',  
    `status` tinyint NOT NULL   COMMENT '类型状态',  
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint NOT NULL   COMMENT '更新时间',  
    `create_by` bigint NOT NULL   COMMENT '创建人',  
    `update_by` bigint NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4;




-- ----------------------------
-- Table structure for `property_item`
-- ----------------------------
-- DROP TABLE IF EXISTS `property_item`;
CREATE TABLE `property_item` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `property_id` bigint NOT NULL   COMMENT '属性id',  
    `title` varchar(50) NOT NULL   COMMENT '属性名',  
    `status` tinyint NOT NULL   COMMENT '类型状态',  
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint NOT NULL   COMMENT '更新时间',  
    `create_by` bigint NOT NULL   COMMENT '创建人',  
    `update_by` bigint NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4;




-- ----------------------------
-- Table structure for `spu`
-- ----------------------------
-- DROP TABLE IF EXISTS `spu`;
CREATE TABLE `spu` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `pic` varchar(200) NOT NULL   COMMENT '配图',  
    `title` varchar(50) NOT NULL   COMMENT '属性名',  
    `status` tinyint NOT NULL   COMMENT '状态',  
    `sales` int NOT NULL   COMMENT '销量',  
    `stock` int NOT NULL   COMMENT '库存',
    `merchant_id` bigint NOT NULL   COMMENT '店铺id',
    `show_price` varchar(50) NOT NULL   COMMENT '展示价格',  
    `pro_item_set` varchar(200)    COMMENT '规格set',
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint NOT NULL   COMMENT '更新时间',  
    `create_by` bigint NOT NULL   COMMENT '创建人',  
    `update_by` bigint NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4;




-- ----------------------------
-- Table structure for `spu_info`
-- ----------------------------
-- DROP TABLE IF EXISTS `spu_info`;
CREATE TABLE `spu_info` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `info` varchar(1000) NULL   COMMENT '图文',
    `spu_id` bigint NOT NULL   COMMENT 'spuId',  
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint NOT NULL   COMMENT '更新时间',  
    `create_by` bigint NOT NULL   COMMENT '创建人',  
    `update_by` bigint NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4;




-- ----------------------------
-- Table structure for `base_classify_spu`
-- ----------------------------
-- DROP TABLE IF EXISTS `base_classify_spu`;
CREATE TABLE `base_classify_spu` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `base_classify_id` bigint NOT NULL   COMMENT '分类id',  
    `merchant_id` bigint NOT NULL   COMMENT '店铺id',  
    `spu_id` bigint NOT NULL   COMMENT 'spuId',  
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint NOT NULL   COMMENT '更新时间',  
    `create_by` bigint NOT NULL   COMMENT '创建人',  
    `update_by` bigint NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4;




-- ----------------------------
-- Table structure for `sku`
-- ----------------------------
-- DROP TABLE IF EXISTS `sku`;
CREATE TABLE `sku` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `title` varchar(200) NOT NULL   COMMENT '配图',  
    `spu_id` bigint NOT NULL   COMMENT '商品id',  
    `status` tinyint NOT NULL   COMMENT '状态',  
    `stock` int NOT NULL   COMMENT '库存',  
    `sales` int NOT NULL   COMMENT '销量',  
    `merchant_id` bigint NOT NULL   COMMENT '店铺id',  
    `price` decimal(10,2) NOT NULL   COMMENT '出售价格',  
    `show_price` varchar(50) NOT NULL   COMMENT '展示价格',  
    `pic` varchar(200) NOT NULL   COMMENT 'pic',
    `pro_item_set` varchar(200) NOT NULL   COMMENT '规格set',
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint NOT NULL   COMMENT '更新时间',  
    `create_by` bigint NOT NULL   COMMENT '创建人',  
    `update_by` bigint NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4;




-- ----------------------------
-- Table structure for `cart`
-- ----------------------------
-- DROP TABLE IF EXISTS `cart`;
CREATE TABLE `cart` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `user_id` bigint NOT NULL   COMMENT '用户id',  
    `sku_id` bigint NOT NULL   COMMENT 'skuid',  
    `merchant_id` bigint NOT NULL   COMMENT 'shopId',  
    `cnt` int NOT NULL   COMMENT '数量',  
    `spu_id` bigint NOT NULL   COMMENT 'spuId',  
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint NOT NULL   COMMENT '更新时间',  
    `create_by` bigint NOT NULL   COMMENT '创建人',  
    `update_by` bigint NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4;




-- ----------------------------
-- Table structure for `address`
-- ----------------------------
-- DROP TABLE IF EXISTS `address`;
CREATE TABLE `address` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `user_id` bigint NOT NULL   COMMENT '用户id',  
    `merchant_id` bigint NOT NULL   COMMENT 'shopId',  
    `name` varchar(50) NOT NULL   COMMENT '收货人',  
    `phone` varchar(50) NOT NULL   COMMENT '电话',  
    `address` varchar(50) NOT NULL   COMMENT '详细地址',  
    `areaId_path` varchar(50)    COMMENT '区域ID路径',  
    `area_id` int    COMMENT '最后一级区域ID',  
    `status` int    COMMENT '',  
    `is_default` bigint NOT NULL   COMMENT '是否默认',  
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint NOT NULL   COMMENT '更新时间',  
    `create_by` bigint NOT NULL   COMMENT '创建人',  
    `update_by` bigint NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `supplier`
-- ----------------------------
-- DROP TABLE IF EXISTS `supplier`;
CREATE TABLE `supplier` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `supplier_name` varchar(50) NOT NULL   COMMENT '供应商名称',
    `phone` varchar(50) NOT NULL   COMMENT '联系电话',
    `address` varchar(100) NOT NULL   COMMENT '供应商地址',
    `contacts` varchar(50) NOT NULL   COMMENT '联系人',
    `description` varchar(100)    COMMENT '备注',
    `status` tinyint    COMMENT '',
    `merchant_id` bigint NOT NULL   COMMENT '商户id',
    `create_at` bigint NOT NULL   COMMENT '创建时间',
    `update_at` bigint NOT NULL   COMMENT '更新时间',
    `create_by` bigint NOT NULL   COMMENT '创建人',
    `update_by` bigint NOT NULL   COMMENT '更新人',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4;




-- ----------------------------
-- Table structure for `stock_in`
-- ----------------------------
-- DROP TABLE IF EXISTS `stock_in`;
CREATE TABLE `stock_in` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `classify_id` bigint NOT NULL   COMMENT '品类id',
    `classify_desc` varchar(100) NOT NULL   COMMENT '商品品类',
    `spu_id` bigint NOT NULL   COMMENT '商品id',
    `spu_title` varchar(50) NOT NULL   COMMENT '商品名称',
    `amount` int NOT NULL   COMMENT '入库量',
    `warehouse_stock` int NOT NULL   COMMENT '仓储库存',
    `description` varchar(100)    COMMENT '备注',
    `sku_id` bigint NOT NULL   COMMENT 'skuid',
    `purchase_price` decimal(10,2) NOT NULL   COMMENT '进价',
    `sku_title` varchar(100) NOT NULL   COMMENT 'sku名称',
    `purchase_date` bigint NOT NULL   COMMENT '采购日期',
    `supplier_name` varchar(100) NOT NULL   COMMENT '供应商名称',
    `supplier_id` bigint NOT NULL   COMMENT '供应商id',
    `action_type` tinyint NOT NULL   COMMENT '操作类型',
    `purchase_no` varchar(100)    COMMENT '采购单号',
    `merchant_id` bigint NOT NULL   COMMENT '商户id',
    `create_at` bigint NOT NULL   COMMENT '创建时间',
    `update_at` bigint NOT NULL   COMMENT '更新时间',
    `create_by` bigint NOT NULL   COMMENT '创建人',
    `update_by` bigint NOT NULL   COMMENT '更新人',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4;




-- ----------------------------
-- Table structure for `stock_out`
-- ----------------------------
-- DROP TABLE IF EXISTS `stock_out`;
CREATE TABLE `stock_out` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `classify_id` bigint NOT NULL   COMMENT '品类id',
    `classify_desc` varchar(100) NOT NULL   COMMENT '商品品类',
    `spu_id` bigint NOT NULL   COMMENT '商品id',
    `spu_title` varchar(50) NOT NULL   COMMENT '商品明',
    `amount` int NOT NULL   COMMENT '出库量',
    `warehouse_stock` int NOT NULL   COMMENT '仓储库存',
    `description` varchar(100)    COMMENT '备注',
    `sku_id` bigint NOT NULL   COMMENT 'skuid',
    `sku_title` varchar(100) NOT NULL   COMMENT 'sku名',
    `outbound_date` bigint NOT NULL   COMMENT '出库日期',
    `action_type` tinyint NOT NULL   COMMENT '操作类型',
    `outbound_no` varchar(100)    COMMENT '出库单号',
    `merchant_id` bigint NOT NULL   COMMENT '商户id',
    `create_at` bigint NOT NULL   COMMENT '创建时间',
    `update_at` bigint NOT NULL   COMMENT '更新时间',
    `create_by` bigint NOT NULL   COMMENT '创建人',
    `update_by` bigint NOT NULL   COMMENT '更新人',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4;














