/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.micro.mall.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.micro.mall.model.UserExpress;
import com.ptteng.micro.mall.service.UserExpressService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserExpressServiceImpl
extends BaseDaoServiceImpl
implements UserExpressService {
    private static final Log log = LogFactory.getLog(UserExpressServiceImpl.class);

    public Long insert(UserExpress userExpress) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + userExpress));
        if (userExpress == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        userExpress.setCreateAt(Long.valueOf(currentTimeMillis));
        userExpress.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)userExpress);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + userExpress));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<UserExpress> insertList(List<UserExpress> userExpressList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (userExpressList == null ? "null" : Integer.valueOf(userExpressList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(userExpressList)) {
            return new ArrayList<UserExpress>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (UserExpress userExpress : userExpressList) {
            userExpress.setCreateAt(Long.valueOf(currentTimeMillis));
            userExpress.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(userExpressList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + userExpressList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(UserExpress.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(UserExpress userExpress) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (userExpress == null ? "null" : userExpress.getId())));
        boolean result = false;
        if (userExpress == null) {
            return true;
        }
        userExpress.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)userExpress);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + userExpress));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + userExpress));
        }
        return result;
    }

    public boolean updateList(List<UserExpress> userExpressList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (userExpressList == null ? "null" : Integer.valueOf(userExpressList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(userExpressList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (UserExpress userExpress : userExpressList) {
            userExpress.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(userExpressList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + userExpressList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + userExpressList.size()));
        return result;
    }

    public UserExpress getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        UserExpress userExpress = null;
        if (id == null) {
            return userExpress;
        }
        try {
            userExpress = (UserExpress)this.dao.get(UserExpress.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return userExpress;
    }

    public List<UserExpress> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List userExpress = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<UserExpress>();
        }
        try {
            userExpress = this.dao.getList(UserExpress.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (userExpress == null ? "null" : Integer.valueOf(userExpress.size()))));
        return userExpress;
    }

    public Long getUserExpressIdByOrdersId(Long ordersId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by ordersId  : " + ordersId));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getUserExpressIdByOrdersId", new Object[]{ordersId});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by ordersId  : " + ordersId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getUserExpressIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserExpressIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countUserExpressIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getUserExpressIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getUserExpressIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

