/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.micro.mall.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.micro.mall.model.Supplier;
import com.ptteng.micro.mall.service.SupplierService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SupplierServiceImpl
extends BaseDaoServiceImpl
implements SupplierService {
    private static final Log log = LogFactory.getLog(SupplierServiceImpl.class);

    public Long insert(Supplier supplier) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + supplier));
        if (supplier == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        supplier.setCreateAt(Long.valueOf(currentTimeMillis));
        supplier.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)supplier);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + supplier));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Supplier> insertList(List<Supplier> supplierList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (supplierList == null ? "null" : Integer.valueOf(supplierList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(supplierList)) {
            return new ArrayList<Supplier>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Supplier supplier : supplierList) {
            supplier.setCreateAt(Long.valueOf(currentTimeMillis));
            supplier.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(supplierList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + supplierList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Supplier.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Supplier supplier) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (supplier == null ? "null" : supplier.getId())));
        boolean result = false;
        if (supplier == null) {
            return true;
        }
        supplier.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)supplier);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + supplier));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + supplier));
        }
        return result;
    }

    public boolean updateList(List<Supplier> supplierList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (supplierList == null ? "null" : Integer.valueOf(supplierList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(supplierList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Supplier supplier : supplierList) {
            supplier.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(supplierList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + supplierList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + supplierList.size()));
        return result;
    }

    public Supplier getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Supplier supplier = null;
        if (id == null) {
            return supplier;
        }
        try {
            supplier = (Supplier)this.dao.get(Supplier.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return supplier;
    }

    public List<Supplier> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List supplier = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Supplier>();
        }
        try {
            supplier = this.dao.getList(Supplier.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (supplier == null ? "null" : Integer.valueOf(supplier.size()))));
        return supplier;
    }

    public List<Long> getSupplierIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getSupplierIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countSupplierIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getSupplierIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getSupplierIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

