/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.micro.mall.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.micro.mall.model.StockOut;
import com.ptteng.micro.mall.service.StockOutService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StockOutServiceImpl
extends BaseDaoServiceImpl
implements StockOutService {
    private static final Log log = LogFactory.getLog(StockOutServiceImpl.class);

    public Long insert(StockOut stockOut) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + stockOut));
        if (stockOut == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        stockOut.setCreateAt(Long.valueOf(currentTimeMillis));
        stockOut.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)stockOut);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + stockOut));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<StockOut> insertList(List<StockOut> stockOutList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (stockOutList == null ? "null" : Integer.valueOf(stockOutList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(stockOutList)) {
            return new ArrayList<StockOut>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (StockOut stockOut : stockOutList) {
            stockOut.setCreateAt(Long.valueOf(currentTimeMillis));
            stockOut.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(stockOutList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + stockOutList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(StockOut.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(StockOut stockOut) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (stockOut == null ? "null" : stockOut.getId())));
        boolean result = false;
        if (stockOut == null) {
            return true;
        }
        stockOut.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)stockOut);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + stockOut));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + stockOut));
        }
        return result;
    }

    public boolean updateList(List<StockOut> stockOutList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (stockOutList == null ? "null" : Integer.valueOf(stockOutList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(stockOutList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (StockOut stockOut : stockOutList) {
            stockOut.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(stockOutList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + stockOutList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + stockOutList.size()));
        return result;
    }

    public StockOut getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        StockOut stockOut = null;
        if (id == null) {
            return stockOut;
        }
        try {
            stockOut = (StockOut)this.dao.get(StockOut.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return stockOut;
    }

    public List<StockOut> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List stockOut = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<StockOut>();
        }
        try {
            stockOut = this.dao.getList(StockOut.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (stockOut == null ? "null" : Integer.valueOf(stockOut.size()))));
        return stockOut;
    }

    public List<Long> getStockOutIdsBySkuId(Long skuId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by skuId,start,limit  : " + skuId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStockOutIdsBySkuId", new Object[]{skuId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by skuId,start,limit)  : " + skuId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getStockOutIdsBySpuId(Long spuId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by spuId,start,limit  : " + spuId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStockOutIdsBySpuId", new Object[]{spuId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by spuId,start,limit)  : " + spuId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countStockOutIdsBySkuId(Long skuId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by skuId  : " + skuId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getStockOutIdsBySkuId", new Object[]{skuId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by skuId)  : " + skuId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countStockOutIdsBySpuId(Long spuId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by spuId  : " + spuId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getStockOutIdsBySpuId", new Object[]{spuId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by spuId)  : " + spuId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getStockOutIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStockOutIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countStockOutIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getStockOutIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getStockOutIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

